<?php

namespace App\Controller;

use App\Entity\TPushPayments;
use App\Repository\TPushPaymentsRepository;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

use Symfony\Component\Validator\Constraints\DateTime;

$mpesa= new \Safaricom\Mpesa\Mpesa();
use Carbon\Carbon;

class PaymentsController extends AbstractController
{
    /**
     * @Route("/payments", name="payments")
     */
    public function index(): Response
    {
        return $this->render('payments/index.html.twig', [
            'controller_name' => 'PaymentsController',
        ]);
    }

     /**
     * Send a new sms
     * @param Request $request
     * @Route("/token", methods={"GET"})
     * @return Response
     */
    public function generateAccessToken()
    {
        $url = 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        $credentials = base64_encode('5Y24J6BAA8XDHTIhNJGBO6vAAOiLFeSI:ErvAQyb7KIwYDcZy');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Authorization: Basic '.$credentials)); //setting a custom header
        curl_setopt($curl,CURLOPT_RETURNTRANSFER,true);
        ////curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $curl_response = curl_exec($curl);

        $json_decode = json_decode($curl_response,true);
        $access_token = $json_decode["access_token"];


        return $access_token;

        // return new Response(json_encode($access_token->access_token));
    }

    function jwt_request($token, $post)
    {
        header('Content-Type: application/json'); // Specify the type of data
        $ch = curl_init('https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest'); // Initialise cURL
        $post = json_encode($post); // Encode the data array into a JSON string
        $authorization = "Authorization: Bearer " . $token; // Prepare the authorisation token
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', $authorization)); // Inject the token into the header
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1); // Specify the request method as POST
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post); // Set the posted fields
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1); // This will follow any redirects
        $result = curl_exec($ch); // Execute the cURL statement
        curl_close($ch); // Close the cURL connection

        return json_decode($result); // Return the received data
    }

    public function lipaNaMpesaPassword()
    {
        $lipa_time = Carbon::rawParse('now')->format('YmdHms');
        //$passkey = "3726d22d0211fe574ac55ab86a174c8883e90220d364fafda48f3a4f508d9c12";
        $passkey = "fb939964fb32a66700db86487471fba58b0d6e2007ec457f862b1344eb479cdc";
        //$BusinessShortCode = 4036617;
        $BusinessShortCode = 7743454;
        $timestamp = $lipa_time;
        $lipa_na_mpesa_password = base64_encode($BusinessShortCode . $passkey . $timestamp);
        return $lipa_na_mpesa_password;
    }

    /**
     * Send a new sms
     * @param Request $request
     * @Route("/mpesarequest", methods={"GET","POST"})
     * @return Response
     */
    public function sendMpesaRequest(Request $request)
    {
        $content = json_decode($request->getContent(), true);

        $myTimeStamp = $content['myTimeStamp'];
        $myPhone = $content['phoneNo'];
        $myAmount = $content['amount'];
        $myAccRefNo = $content['accRef'];
        $myId = $content['id'];

        $token = $this->generateAccessToken(); // Get your token from a cookie or database

        $post = [
            //Fill in the request parameters with valid values
            'BusinessShortCode' => 7743454,
            //'BusinessShortCode'=> 4036617,
            'Password' => $this->lipaNaMpesaPassword(),
            'Timestamp' => Carbon::rawParse('now')->format('YmdHms'),
            'TransactionType' => "CustomerPayBillOnline",
            'Amount' => $myAmount,
            'PartyA' => $myPhone,
            'PartyB' => 7743454,
            //'PartyB' =>  4036617,
            'PhoneNumber' => $myPhone,

            'CallBackURL' => "https://chetrosacco.com/chetroexp/callback_url.php?paymentid",
            //'CallBackURL' => "https://server001.dreamwavesservers.co.ke/index.php/forms/bnwk83smdbwf9r2arkjspk477venv2e9/",

            'AccountReference' => $myAccRefNo,
             'TransactionDesc' => "Kindly pay this invoice for your application to continue"
        ]; // Array of data with a trigger

        $response = $this->jwt_request($token, $post); // Send or retrieve data
        $response_code = $response->ResponseCode;

        if ($response_code == "0") {

            $date = date("Y-m-d");

            $paymentPush = new TPushPayments();
            // $paymentPush->setMyTimestamp($myTimeStamp);
            $paymentPush->setPhoneNo($myPhone);
            $paymentPush->setAmount($myAmount);
            $paymentPush->setMerchantrequestId($response->MerchantRequestID);
            $paymentPush->setCheckoutrequestId($response->CheckoutRequestID);
            $paymentPush->setAccountRef($myAccRefNo);
            $paymentPush->setRequestCode($response->ResponseCode);
            $paymentPush->setResponseDesc($response->ResponseDescription);
            // $paymentPush->setWholeResponse($response);
            $paymentPush->setInvoiceId($myId);
            $paymentPush->setConfirmed('NO');
            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($paymentPush);
            $entityManager->flush();
        }
        return new Response(json_encode($response));

    }

}
