<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAccountsTransactionsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\RangeFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\OrderFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Validator\Constraints\DateTime;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_accounts_transactions:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_accounts_transactions:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "transactionDocDate": "exact", "transactionType": "exact", "coaCode": "exact", "coa": "exact", "account": "exact" })
 * @ApiFilter(DateFilter::class, properties={"transactionSystemDate"})
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(OrderFilter::class, properties={ "transactionSystemDate": "asc" })
 * @ApiFilter(RangeFilter::class, properties={"coaCode"})
 * @ORM\Entity(repositoryClass=TAccountsTransactionsRepository::class)
 */

class TAccountsTransactions
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tAccountsTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tAccountsTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $stage;

    /**
     * @ORM\ManyToOne(targetEntity=TServiceFees::class, inversedBy="tAccountsTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $service;

    /**
     * @ORM\ManyToOne(targetEntity=TInvoices::class, inversedBy="tAccountsTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $invoice;

    /**
     * @ORM\ManyToOne(targetEntity=TPayments::class, inversedBy="tAccountsTransactions")
     */
    private $payment;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tAccountsTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $coa;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $coaCode;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $transactionType;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $narration;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $balance;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $drCr;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="accountTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tAccountsTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $user;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $transactionDocDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $month;

    /**
     * @ORM\ManyToOne(targetEntity=TQueManager::class, inversedBy="tAccountsTransactions")
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $que;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_accounts_transactions:read", "t_accounts_transactions:write"})
     */
    private $transactionsAccsTemps;

    /**
     * @ORM\ManyToOne(targetEntity=TInventory::class, inversedBy="tAccountsTransactions")
     */
    private $item;

    public function __construct()
    {
        $this->tTransactionsDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getService(): ?TServiceFees
    {
        return $this->service;
    }

    public function setService(?TServiceFees $service): self
    {
        $this->service = $service;

        return $this;
    }

    public function getInvoice(): ?TInvoices
    {
        return $this->invoice;
    }

    public function setInvoice(?TInvoices $invoice): self
    {
        $this->invoice = $invoice;

        return $this;
    }

    public function getPayment(): ?TPayments
    {
        return $this->payment;
    }

    public function setPayment(?TPayments $payment): self
    {
        $this->payment = $payment;

        return $this;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    public function getCoaCode(): ?int
    {
        return $this->coaCode;
    }

    public function setCoaCode(?int $coaCode): self
    {
        $this->coaCode = $coaCode;

        return $this;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    public function getNarration(): ?string
    {
        return $this->narration;
    }

    public function setNarration(?string $narration): self
    {
        $this->narration = $narration;

        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $balance): self
    {
        $this->balance = $balance;

        return $this;
    }

    public function getDrCr(): ?string
    {
        return $this->drCr;
    }

    public function setDrCr(?string $drCr): self
    {
        $this->drCr = $drCr;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setAccountTransactions($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getAccountTransactions() === $this) {
                $tTransactionsDetail->setAccountTransactions(null);
            }
        }

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactionDocDate(): ?\DateTimeInterface
    {
        return $this->transactionDocDate;
    }

    public function setTransactionDocDate(?\DateTimeInterface $transactionDocDate): self
    {
        $this->transactionDocDate = $transactionDocDate;

        return $this;
    }

    public function getYear(): ?string
    {
        return $this->year;
    }

    public function setYear(?string $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?string
    {
        return $this->month;
    }

    public function setMonth(?string $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getQue(): ?TQueManager
    {
        return $this->que;
    }

    public function setQue(?TQueManager $que): self
    {
        $this->que = $que;

        return $this;
    }

    public function getTransactionsAccsTemps(): ?int
    {
        return $this->transactionsAccsTemps;
    }

    public function setTransactionsAccsTemps(?int $transactionsAccsTemps): self
    {
        $this->transactionsAccsTemps = $transactionsAccsTemps;

        return $this;
    }

    public function getItem(): ?TInventory
    {
        return $this->item;
    }

    public function setItem(?TInventory $item): self
    {
        $this->item = $item;

        return $this;
    }
}
