<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAccountsTransactionsTempRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_accounts_transactions_temp:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_accounts_transactions_temp:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "account": "exact", "status": "exact", "transactionType": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TAccountsTransactionsTempRepository::class)
 */

class TAccountsTransactionsTemp
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TQueManager::class, inversedBy="tAccountsTransactionsTemps")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $que;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tAccountsTransactionsTemps")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tAccountsTransactionsTemps")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $stage;

    /**
     * @ORM\ManyToOne(targetEntity=TServiceFees::class, inversedBy="tAccountsTransactionsTemps")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $service;

    /**
     * @ORM\ManyToOne(targetEntity=TInvoices::class, inversedBy="tAccountsTransactionsTemps")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $invoice;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $transactionType;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $balance;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $transactiondDocDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $month;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetailsTemps::class, mappedBy="accountTransactionsTemps")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $tTransactionsDetailsTemps;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $transactionSystemNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity=TSalariesDefined::class, inversedBy="tAccountsTransactionsTemps")
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $salaryDefined;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $salaryType;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $itemDescription;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $salaryAdvanceAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $otherEarnsDeductAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_accounts_transactions_temp:read", "t_accounts_transactions_temp:write"})
     */
    private $salaryNetAmount;

    public function __construct()
    {
        $this->tTransactionsDetailsTemps = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getQue(): ?TQueManager
    {
        return $this->que;
    }

    public function setQue(?TQueManager $que): self
    {
        $this->que = $que;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getService(): ?TServiceFees
    {
        return $this->service;
    }

    public function setService(?TServiceFees $service): self
    {
        $this->service = $service;

        return $this;
    }

    public function getInvoice(): ?TInvoices
    {
        return $this->invoice;
    }

    public function setInvoice(?TInvoices $invoice): self
    {
        $this->invoice = $invoice;

        return $this;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $balance): self
    {
        $this->balance = $balance;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactiondDocDate(): ?\DateTimeInterface
    {
        return $this->transactiondDocDate;
    }

    public function setTransactiondDocDate(?\DateTimeInterface $transactiondDocDate): self
    {
        $this->transactiondDocDate = $transactiondDocDate;

        return $this;
    }

    public function getYear(): ?string
    {
        return $this->year;
    }

    public function setYear(?string $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?string
    {
        return $this->month;
    }

    public function setMonth(?string $month): self
    {
        $this->month = $month;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetailsTemps[]
     */
    public function getTTransactionsDetailsTemps(): Collection
    {
        return $this->tTransactionsDetailsTemps;
    }

    public function addTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if (!$this->tTransactionsDetailsTemps->contains($tTransactionsDetailsTemp)) {
            $this->tTransactionsDetailsTemps[] = $tTransactionsDetailsTemp;
            $tTransactionsDetailsTemp->setAccountTransactionsTemps($this);
        }

        return $this;
    }

    public function removeTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if ($this->tTransactionsDetailsTemps->removeElement($tTransactionsDetailsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetailsTemp->getAccountTransactionsTemps() === $this) {
                $tTransactionsDetailsTemp->setAccountTransactionsTemps(null);
            }
        }

        return $this;
    }

    public function getTransactionSystemNo(): ?string
    {
        return $this->transactionSystemNo;
    }

    public function setTransactionSystemNo(?string $transactionSystemNo): self
    {
        $this->transactionSystemNo = $transactionSystemNo;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getSalaryDefined(): ?TSalariesDefined
    {
        return $this->salaryDefined;
    }

    public function setSalaryDefined(?TSalariesDefined $salaryDefined): self
    {
        $this->salaryDefined = $salaryDefined;

        return $this;
    }

    public function getSalaryType(): ?string
    {
        return $this->salaryType;
    }

    public function setSalaryType(?string $salaryType): self
    {
        $this->salaryType = $salaryType;

        return $this;
    }

    public function getItemDescription(): ?string
    {
        return $this->itemDescription;
    }

    public function setItemDescription(?string $itemDescription): self
    {
        $this->itemDescription = $itemDescription;

        return $this;
    }

    public function getSalaryAdvanceAmount(): ?string
    {
        return $this->salaryAdvanceAmount;
    }

    public function setSalaryAdvanceAmount(?string $salaryAdvanceAmount): self
    {
        $this->salaryAdvanceAmount = $salaryAdvanceAmount;

        return $this;
    }

    public function getOtherEarnsDeductAmount(): ?string
    {
        return $this->otherEarnsDeductAmount;
    }

    public function setOtherEarnsDeductAmount(?string $otherEarnsDeductAmount): self
    {
        $this->otherEarnsDeductAmount = $otherEarnsDeductAmount;

        return $this;
    }

    public function getSalaryNetAmount(): ?string
    {
        return $this->salaryNetAmount;
    }

    public function setSalaryNetAmount(?string $salaryNetAmount): self
    {
        $this->salaryNetAmount = $salaryNetAmount;

        return $this;
    }
}
