<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAllAccountsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\RangeFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_all_accounts:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_all_accounts:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "stage": "exact", "accountType": "exact", "status": "exact", "coa":"exact", "transactionDetails": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(RangeFilter::class, properties={"accountType"})
 * @ORM\Entity(repositoryClass=TAllAccountsRepository::class)
 */
class TAllAccounts
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write", "t_que_manager:read", "t_transactions_details:read", "t_invoices:read", "t_accounts_transactions_temp:read", "t_wards_beds:read", "t_wards_floors:read", "t_wards_in_patient:read"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tAllAccounts")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $coa;

    /**
     * @ORM\ManyToOne(targetEntity=TSponsors::class, inversedBy="tAllAccounts")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $sponsor;

    /**
     * @ORM\OneToMany(targetEntity=TStagesTimelines::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tStagesTimelines;

    /**
     * @ORM\ManyToOne(targetEntity=TWards::class, inversedBy="tAllAccounts")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $ward;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write", "t_que_manager:read", "t_transactions_details:read", "t_invoices:read", "t_sponsors_assignings:read", "t_wards_in_patient:read", "t_wards_beds:read", "t_wards_floors:read"})
     */
    private $accountNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write", "t_que_manager:read", "t_transactions_details:read", "t_invoices:read", "t_sponsors_assignings:read", "t_accounts_transactions_temp:read", "t_accounts_transactions:read", "t_wards_in_patient:read", "t_wards_beds:read", "t_wards_floors:read"})
     */
    private $accountName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $accountType;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $accountDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $dob;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $idNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $gender;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $maritalStatus;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $religion;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write", "t_invoices:read", "t_wards_in_patient:read", "t_wards_beds:read", "t_wards_floors:read"})
     */
    private $phone;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $alternativePhone;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $nextOfKinName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $nextOfKinRelation;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $nextOfKinContact;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $bloodGroup;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $allergies;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tInvoices;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tAccountsTransactions;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TSponsorsAssigning::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tSponsorsAssignings;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $month;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $amount;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TQueManager::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tQueManagers;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetailsTemps::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tTransactionsDetailsTemps;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactionsTemp::class, mappedBy="account")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $tAccountsTransactionsTemps;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tAllAccounts")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity=TSalaryAdvances::class, mappedBy="account")
     */
    private $tSalaryAdvances;

    /**
     * @ORM\OneToMany(targetEntity=TOtherEarningsDeductions::class, mappedBy="account")
     */
    private $tOtherEarningsDeductions;

    /**
     * @ORM\OneToMany(targetEntity=TBedsAssignings::class, mappedBy="account")
     */
    private $tBedsAssignings;

    /**
     * @ORM\ManyToOne(targetEntity=TWardsInPatient::class, inversedBy="tAllAccounts")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $currentAdmissionWard;

    /**
     * @ORM\ManyToOne(targetEntity=TWardsFloors::class, inversedBy="tAllAccounts")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $currentAdmissionFloor;

    /**
     * @ORM\ManyToOne(targetEntity=TWardsBeds::class, inversedBy="tAllAccounts")
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $currentAdmissionBed;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_all_accounts:read", "t_all_accounts:write"})
     */
    private $inPatientStatus;

    public function __construct()
    {
        $this->tStagesTimelines = new ArrayCollection();
        $this->tInvoices = new ArrayCollection();
        $this->tAccountsTransactions = new ArrayCollection();
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tSponsorsAssignings = new ArrayCollection();
        $this->tQueManagers = new ArrayCollection();
        $this->tTransactionsDetailsTemps = new ArrayCollection();
        $this->tAccountsTransactionsTemps = new ArrayCollection();
        $this->tSalaryAdvances = new ArrayCollection();
        $this->tOtherEarningsDeductions = new ArrayCollection();
        $this->tBedsAssignings = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    public function getSponsor(): ?TSponsors
    {
        return $this->sponsor;
    }

    public function setSponsor(?TSponsors $sponsor): self
    {
        $this->sponsor = $sponsor;

        return $this;
    }

    /**
     * @return Collection|TStagesTimelines[]
     */
    public function getTStagesTimelines(): Collection
    {
        return $this->tStagesTimelines;
    }

    public function addTStagesTimeline(TStagesTimelines $tStagesTimeline): self
    {
        if (!$this->tStagesTimelines->contains($tStagesTimeline)) {
            $this->tStagesTimelines[] = $tStagesTimeline;
            $tStagesTimeline->setAccount($this);
        }

        return $this;
    }

    public function removeTStagesTimeline(TStagesTimelines $tStagesTimeline): self
    {
        if ($this->tStagesTimelines->removeElement($tStagesTimeline)) {
            // set the owning side to null (unless already changed)
            if ($tStagesTimeline->getAccount() === $this) {
                $tStagesTimeline->setAccount(null);
            }
        }

        return $this;
    }

    public function getWard(): ?TWards
    {
        return $this->ward;
    }

    public function setWard(?TWards $ward): self
    {
        $this->ward = $ward;

        return $this;
    }

    public function getAccountNo(): ?string
    {
        return $this->accountNo;
    }

    public function setAccountNo(?string $accountNo): self
    {
        $this->accountNo = $accountNo;

        return $this;
    }

    public function getAccountName(): ?string
    {
        return $this->accountName;
    }

    public function setAccountName(?string $accountName): self
    {
        $this->accountName = $accountName;

        return $this;
    }

    public function getAccountType(): ?string
    {
        return $this->accountType;
    }

    public function setAccountType(?string $accountType): self
    {
        $this->accountType = $accountType;

        return $this;
    }

    public function getAccountDate(): ?\DateTimeInterface
    {
        return $this->accountDate;
    }

    public function setAccountDate(?\DateTimeInterface $accountDate): self
    {
        $this->accountDate = $accountDate;

        return $this;
    }

    public function getDob(): ?\DateTimeInterface
    {
        return $this->dob;
    }

    public function setDob(?\DateTimeInterface $dob): self
    {
        $this->dob = $dob;

        return $this;
    }

    public function getIdNo(): ?string
    {
        return $this->idNo;
    }

    public function setIdNo(?string $idNo): self
    {
        $this->idNo = $idNo;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    public function getMaritalStatus(): ?string
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?string $maritalStatus): self
    {
        $this->maritalStatus = $maritalStatus;

        return $this;
    }

    public function getReligion(): ?string
    {
        return $this->religion;
    }

    public function setReligion(?string $religion): self
    {
        $this->religion = $religion;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    public function getAlternativePhone(): ?string
    {
        return $this->alternativePhone;
    }

    public function setAlternativePhone(?string $alternativePhone): self
    {
        $this->alternativePhone = $alternativePhone;

        return $this;
    }

    public function getNextOfKinName(): ?string
    {
        return $this->nextOfKinName;
    }

    public function setNextOfKinName(?string $nextOfKinName): self
    {
        $this->nextOfKinName = $nextOfKinName;

        return $this;
    }

    public function getNextOfKinRelation(): ?string
    {
        return $this->nextOfKinRelation;
    }

    public function setNextOfKinRelation(?string $nextOfKinRelation): self
    {
        $this->nextOfKinRelation = $nextOfKinRelation;

        return $this;
    }

    public function getNextOfKinContact(): ?string
    {
        return $this->nextOfKinContact;
    }

    public function setNextOfKinContact(?string $nextOfKinContact): self
    {
        $this->nextOfKinContact = $nextOfKinContact;

        return $this;
    }

    public function getBloodGroup(): ?string
    {
        return $this->bloodGroup;
    }

    public function setBloodGroup(?string $bloodGroup): self
    {
        $this->bloodGroup = $bloodGroup;

        return $this;
    }

    public function getAllergies(): ?string
    {
        return $this->allergies;
    }

    public function setAllergies(?string $allergies): self
    {
        $this->allergies = $allergies;

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setAccount($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getAccount() === $this) {
                $tInvoice->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransactions)) {
            $this->tAccountsTransactions[] = $tAccountsTransactions;
            $tAccountsTransactions->setAccount($this);
        }

        return $this;
    }

    public function removeTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransactions)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactions->getAccount() === $this) {
                $tAccountsTransactions->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setAccount($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getAccount() === $this) {
                $tTransactionsDetail->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSponsorsAssigning[]
     */
    public function getTSponsorsAssignings(): Collection
    {
        return $this->tSponsorsAssignings;
    }

    public function addTSponsorsAssigning(TSponsorsAssigning $tSponsorsAssigning): self
    {
        if (!$this->tSponsorsAssignings->contains($tSponsorsAssigning)) {
            $this->tSponsorsAssignings[] = $tSponsorsAssigning;
            $tSponsorsAssigning->setAccount($this);
        }

        return $this;
    }

    public function removeTSponsorsAssigning(TSponsorsAssigning $tSponsorsAssigning): self
    {
        if ($this->tSponsorsAssignings->removeElement($tSponsorsAssigning)) {
            // set the owning side to null (unless already changed)
            if ($tSponsorsAssigning->getAccount() === $this) {
                $tSponsorsAssigning->setAccount(null);
            }
        }

        return $this;
    }

    public function getYear(): ?int
    {
        return $this->year;
    }

    public function setYear(?int $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?int
    {
        return $this->month;
    }

    public function setMonth(?int $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TQueManager[]
     */
    public function getTQueManagers(): Collection
    {
        return $this->tQueManagers;
    }

    public function addTQueManager(TQueManager $tQueManager): self
    {
        if (!$this->tQueManagers->contains($tQueManager)) {
            $this->tQueManagers[] = $tQueManager;
            $tQueManager->setAccount($this);
        }

        return $this;
    }

    public function removeTQueManager(TQueManager $tQueManager): self
    {
        if ($this->tQueManagers->removeElement($tQueManager)) {
            // set the owning side to null (unless already changed)
            if ($tQueManager->getAccount() === $this) {
                $tQueManager->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetailsTemps[]
     */
    public function getTTransactionsDetailsTemps(): Collection
    {
        return $this->tTransactionsDetailsTemps;
    }

    public function addTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if (!$this->tTransactionsDetailsTemps->contains($tTransactionsDetailsTemp)) {
            $this->tTransactionsDetailsTemps[] = $tTransactionsDetailsTemp;
            $tTransactionsDetailsTemp->setAccount($this);
        }

        return $this;
    }

    public function removeTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if ($this->tTransactionsDetailsTemps->removeElement($tTransactionsDetailsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetailsTemp->getAccount() === $this) {
                $tTransactionsDetailsTemp->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactionsTemp[]
     */
    public function getTAccountsTransactionsTemps(): Collection
    {
        return $this->tAccountsTransactionsTemps;
    }

    public function addTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if (!$this->tAccountsTransactionsTemps->contains($tAccountsTransactionsTemp)) {
            $this->tAccountsTransactionsTemps[] = $tAccountsTransactionsTemp;
            $tAccountsTransactionsTemp->setAccount($this);
        }

        return $this;
    }

    public function removeTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if ($this->tAccountsTransactionsTemps->removeElement($tAccountsTransactionsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactionsTemp->getAccount() === $this) {
                $tAccountsTransactionsTemp->setAccount(null);
            }
        }

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|TSalaryAdvances[]
     */
    public function getTSalaryAdvances(): Collection
    {
        return $this->tSalaryAdvances;
    }

    public function addTSalaryAdvance(TSalaryAdvances $tSalaryAdvance): self
    {
        if (!$this->tSalaryAdvances->contains($tSalaryAdvance)) {
            $this->tSalaryAdvances[] = $tSalaryAdvance;
            $tSalaryAdvance->setAccount($this);
        }

        return $this;
    }

    public function removeTSalaryAdvance(TSalaryAdvances $tSalaryAdvance): self
    {
        if ($this->tSalaryAdvances->removeElement($tSalaryAdvance)) {
            // set the owning side to null (unless already changed)
            if ($tSalaryAdvance->getAccount() === $this) {
                $tSalaryAdvance->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TOtherEarningsDeductions[]
     */
    public function getTOtherEarningsDeductions(): Collection
    {
        return $this->tOtherEarningsDeductions;
    }

    public function addTOtherEarningsDeduction(TOtherEarningsDeductions $tOtherEarningsDeduction): self
    {
        if (!$this->tOtherEarningsDeductions->contains($tOtherEarningsDeduction)) {
            $this->tOtherEarningsDeductions[] = $tOtherEarningsDeduction;
            $tOtherEarningsDeduction->setAccount($this);
        }

        return $this;
    }

    public function removeTOtherEarningsDeduction(TOtherEarningsDeductions $tOtherEarningsDeduction): self
    {
        if ($this->tOtherEarningsDeductions->removeElement($tOtherEarningsDeduction)) {
            // set the owning side to null (unless already changed)
            if ($tOtherEarningsDeduction->getAccount() === $this) {
                $tOtherEarningsDeduction->setAccount(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TBedsAssignings[]
     */
    public function getTBedsAssignings(): Collection
    {
        return $this->tBedsAssignings;
    }

    public function addTBedsAssigning(TBedsAssignings $tBedsAssigning): self
    {
        if (!$this->tBedsAssignings->contains($tBedsAssigning)) {
            $this->tBedsAssignings[] = $tBedsAssigning;
            $tBedsAssigning->setAccount($this);
        }

        return $this;
    }

    public function removeTBedsAssigning(TBedsAssignings $tBedsAssigning): self
    {
        if ($this->tBedsAssignings->removeElement($tBedsAssigning)) {
            // set the owning side to null (unless already changed)
            if ($tBedsAssigning->getAccount() === $this) {
                $tBedsAssigning->setAccount(null);
            }
        }

        return $this;
    }

    public function getCurrentAdmissionWard(): ?TWardsInPatient
    {
        return $this->currentAdmissionWard;
    }

    public function setCurrentAdmissionWard(?TWardsInPatient $currentAdmissionWard): self
    {
        $this->currentAdmissionWard = $currentAdmissionWard;

        return $this;
    }

    public function getCurrentAdmissionFloor(): ?TWardsFloors
    {
        return $this->currentAdmissionFloor;
    }

    public function setCurrentAdmissionFloor(?TWardsFloors $currentAdmissionFloor): self
    {
        $this->currentAdmissionFloor = $currentAdmissionFloor;

        return $this;
    }

    public function getCurrentAdmissionBed(): ?TWardsBeds
    {
        return $this->currentAdmissionBed;
    }

    public function setCurrentAdmissionBed(?TWardsBeds $currentAdmissionBed): self
    {
        $this->currentAdmissionBed = $currentAdmissionBed;

        return $this;
    }

    public function getInPatientStatus(): ?string
    {
        return $this->inPatientStatus;
    }

    public function setInPatientStatus(?string $inPatientStatus): self
    {
        $this->inPatientStatus = $inPatientStatus;

        return $this;
    }

}
