<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TBedsAssigningsRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_beds_assignings:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_beds_assignings:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TBedsAssigningsRepository::class)
 */

class TBedsAssignings
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_beds_assignings:read", "t_beds_assignings:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TWardsBeds::class, inversedBy="tBedsAssignings")
     * @Groups({"t_beds_assignings:read", "t_beds_assignings:write"})
     */
    private $bed;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tBedsAssignings")
     * @Groups({"t_beds_assignings:read", "t_beds_assignings:write"})
     */
    private $account;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_beds_assignings:read", "t_beds_assignings:write"})
     */
    private $assignDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_beds_assignings:read", "t_beds_assignings:write"})
     */
    private $status;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getBed(): ?TWardsBeds
    {
        return $this->bed;
    }

    public function setBed(?TWardsBeds $bed): self
    {
        $this->bed = $bed;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getAssignDate(): ?\DateTimeInterface
    {
        return $this->assignDate;
    }

    public function setAssignDate(?\DateTimeInterface $assignDate): self
    {
        $this->assignDate = $assignDate;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }
}
