<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCoaCategoriesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_coa_categories:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_coa_categories:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCoaCategoriesRepository::class)
 */

class TCoaCategories
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_coa_categories:read", "t_coa_categories:write", "t_coas:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_coa_categories:read", "t_coa_categories:write"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_coa_categories:read", "t_coa_categories:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TCoas::class, mappedBy="coaCategory")
     * @Groups({"t_coa_categories:read", "t_coa_categories:write"})
     */
    private $tCoas;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_coa_categories:read", "t_coa_categories:write"})
     */
    private $code;

    public function __construct()
    {
        $thisphp->tCoas = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TCoas[]
     */
    public function getTCoas(): Collection
    {
        return $this->tCoas;
    }

    public function addTCoa(TCoas $tCoa): self
    {
        if (!$this->tCoas->contains($tCoa)) {
            $this->tCoas[] = $tCoa;
            $tCoa->setCoaCategory($this);
        }

        return $this;
    }

    public function removeTCoa(TCoas $tCoa): self
    {
        if ($this->tCoas->removeElement($tCoa)) {
            // set the owning side to null (unless already changed)
            if ($tCoa->getCoaCategory() === $this) {
                $tCoa->setCoaCategory(null);
            }
        }

        return $this;
    }

    public function getCode(): ?int
    {
        return $this->code;
    }

    public function setCode(?int $code): self
    {
        $this->code = $code;

        return $this;
    }
}
