<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCoasRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_coas:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_coas:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "coaCategory": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCoasRepository::class)
 */

class TCoas
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_coas:read", "t_coas:write", "t_service_fees:read", "t_sponsors_assignings:read", "t_invoices:read", "t_inventory:read", "t_transactions_details:read", "t_payslip_items:read", "t_other_earnings_deductions:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCoaCategories::class, inversedBy="tCoas")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $coaCategory;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_coas:read", "t_coas:write", "t_payslip_items:read"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TAllAccounts::class, mappedBy="coa")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $tAllAccounts;

    /**
     * @ORM\OneToMany(targetEntity=TServiceFees::class, mappedBy="coa")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $tServiceFees;

    /**
     * @ORM\OneToMany(targetEntity=TPayments::class, mappedBy="coa")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $tPayments;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="coa")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $tAccountsTransactions;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_coas:read", "t_coas:write", "t_transactions_details:read", "t_sponsors_assignings:read", "t_invoices:read", "t_inventory:read" })
     */
    private $code;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="coa")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TServicesCategories::class, mappedBy="inventoryCoa")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $tServicesCategories;

    /**
     * @ORM\OneToMany(targetEntity=TSponsors::class, mappedBy="coa")
     * @Groups({"t_coas:read", "t_coas:write"})
     */
    private $tSponsors;

    /**
     * @ORM\OneToMany(targetEntity=TInventoryCategories::class, mappedBy="coa")
     * @Groups({"t_coas:read", "t_coas:write" })
     */
    private $tInventoryCategories;

    /**
     * @ORM\OneToMany(targetEntity=TPayslipItems::class, mappedBy="coa")
     */
    private $tPayslipItems;

    /**
     * @ORM\OneToMany(targetEntity=TOtherEarningsDeductions::class, mappedBy="coa")
     */
    private $tOtherEarningsDeductions;

    public function __construct()
    {
        $this->tAllAccounts = new ArrayCollection();
        $this->tServiceFees = new ArrayCollection();
        $this->tPayments = new ArrayCollection();
        $this->tAccountsTransactions = new ArrayCollection();
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tServicesCategories = new ArrayCollection();
        $this->tSponsors = new ArrayCollection();
        $this->tInventoryCategories = new ArrayCollection();
        $this->tPayslipItems = new ArrayCollection();
        $this->tOtherEarningsDeductions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCoaCategory(): ?TCoaCategories
    {
        return $this->coaCategory;
    }

    public function setCoaCategory(?TCoaCategories $coaCategory): self
    {
        $this->coaCategory = $coaCategory;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TAllAccounts[]
     */
    public function getTAllAccounts(): Collection
    {
        return $this->tAllAccounts;
    }

    public function addTAllAccounts(TAllAccounts $tAllAccounts): self
    {
        if (!$this->tAllAccounts->contains($tAllAccounts)) {
            $this->tAllAccounts[] = $tAllAccounts;
            $tAllAccounts->setCoa($this);
        }

        return $this;
    }

    public function removeTAllAccounts(TAllAccounts $tAllAccounts): self
    {
        if ($this->tAllAccounts->removeElement($tAllAccounts)) {
            // set the owning side to null (unless already changed)
            if ($tAllAccounts->getCoa() === $this) {
                $tAllAccounts->setCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TServiceFees[]
     */
    public function getTServiceFees(): Collection
    {
        return $this->tServiceFees;
    }

    public function addTServiceFee(TServiceFees $tServiceFee): self
    {
        if (!$this->tServiceFees->contains($tServiceFee)) {
            $this->tServiceFees[] = $tServiceFee;
            $tServiceFee->setCoa($this);
        }

        return $this;
    }

    public function removeTServiceFee(TServiceFees $tServiceFee): self
    {
        if ($this->tServiceFees->removeElement($tServiceFee)) {
            // set the owning side to null (unless already changed)
            if ($tServiceFee->getCoa() === $this) {
                $tServiceFee->setCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPayments[]
     */
    public function getTPayments(): Collection
    {
        return $this->tPayments;
    }

    public function addTPayments(TPayments $tPayments): self
    {
        if (!$this->tPayments->contains($tPayments)) {
            $this->tPayments[] = $tPayments;
            $tPayments->setCoa($this);
        }

        return $this;
    }

    public function removeTPayments(TPayments $tPayments): self
    {
        if ($this->tPayments->removeElement($tPayments)) {
            // set the owning side to null (unless already changed)
            if ($tPayments->getCoa() === $this) {
                $tPayments->setCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransactions)) {
            $this->tAccountsTransactions[] = $tAccountsTransactions;
            $tAccountsTransactions->setCoa($this);
        }

        return $this;
    }

    public function removeTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransactions)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactions->getCoa() === $this) {
                $tAccountsTransactions->setCoa(null);
            }
        }

        return $this;
    }

    public function getCode(): ?int
    {
        return $this->code;
    }

    public function setCode(?int $code): self
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setCoa($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getCoa() === $this) {
                $tTransactionsDetail->setCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TServicesCategories[]
     */
    public function getTServicesCategories(): Collection
    {
        return $this->tServicesCategories;
    }

    public function addTServicesCategory(TServicesCategories $tServicesCategory): self
    {
        if (!$this->tServicesCategories->contains($tServicesCategory)) {
            $this->tServicesCategories[] = $tServicesCategory;
            $tServicesCategory->setInventoryCoa($this);
        }

        return $this;
    }

    public function removeTServicesCategory(TServicesCategories $tServicesCategory): self
    {
        if ($this->tServicesCategories->removeElement($tServicesCategory)) {
            // set the owning side to null (unless already changed)
            if ($tServicesCategory->getInventoryCoa() === $this) {
                $tServicesCategory->setInventoryCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSponsors[]
     */
    public function getTSponsors(): Collection
    {
        return $this->tSponsors;
    }

    public function addTSponsor(TSponsors $tSponsor): self
    {
        if (!$this->tSponsors->contains($tSponsor)) {
            $this->tSponsors[] = $tSponsor;
            $tSponsor->setCoa($this);
        }

        return $this;
    }

    public function removeTSponsor(TSponsors $tSponsor): self
    {
        if ($this->tSponsors->removeElement($tSponsor)) {
            // set the owning side to null (unless already changed)
            if ($tSponsor->getCoa() === $this) {
                $tSponsor->setCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TInventoryCategories[]
     */
    public function getTInventoryCategories(): Collection
    {
        return $this->tInventoryCategories;
    }

    public function addTInventoryCategory(TInventoryCategories $tInventoryCategory): self
    {
        if (!$this->tInventoryCategories->contains($tInventoryCategory)) {
            $this->tInventoryCategories[] = $tInventoryCategory;
            $tInventoryCategory->setCoa($this);
        }

        return $this;
    }

    public function removeTInventoryCategory(TInventoryCategories $tInventoryCategory): self
    {
        if ($this->tInventoryCategories->removeElement($tInventoryCategory)) {
            // set the owning side to null (unless already changed)
            if ($tInventoryCategory->getCoa() === $this) {
                $tInventoryCategory->setCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPayslipItems[]
     */
    public function getTPayslipItems(): Collection
    {
        return $this->tPayslipItems;
    }

    public function addTPayslipItem(TPayslipItems $tPayslipItem): self
    {
        if (!$this->tPayslipItems->contains($tPayslipItem)) {
            $this->tPayslipItems[] = $tPayslipItem;
            $tPayslipItem->setCoa($this);
        }

        return $this;
    }

    public function removeTPayslipItem(TPayslipItems $tPayslipItem): self
    {
        if ($this->tPayslipItems->removeElement($tPayslipItem)) {
            // set the owning side to null (unless already changed)
            if ($tPayslipItem->getCoa() === $this) {
                $tPayslipItem->setCoa(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TOtherEarningsDeductions[]
     */
    public function getTOtherEarningsDeductions(): Collection
    {
        return $this->tOtherEarningsDeductions;
    }

    public function addTOtherEarningsDeduction(TOtherEarningsDeductions $tOtherEarningsDeduction): self
    {
        if (!$this->tOtherEarningsDeductions->contains($tOtherEarningsDeduction)) {
            $this->tOtherEarningsDeductions[] = $tOtherEarningsDeduction;
            $tOtherEarningsDeduction->setCoa($this);
        }

        return $this;
    }

    public function removeTOtherEarningsDeduction(TOtherEarningsDeductions $tOtherEarningsDeduction): self
    {
        if ($this->tOtherEarningsDeductions->removeElement($tOtherEarningsDeduction)) {
            // set the owning side to null (unless already changed)
            if ($tOtherEarningsDeduction->getCoa() === $this) {
                $tOtherEarningsDeduction->setCoa(null);
            }
        }

        return $this;
    }
}
