<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountiesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_counties:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_counties:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountiesRepository::class)
 */

class TCounties
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_counties:read", "t_counties:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_counties:read", "t_counties:write", "t_sub_counties:read", "t_sub_counties:write"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_counties:read", "t_counties:write"})
     */
    private $code;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_counties:read", "t_counties:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TSubCounties::class, mappedBy="county")
     * @Groups({"t_counties:read", "t_counties:write"})
     */
    private $tSubCounties;

    public function __construct()
    {
        $this->tSubCounties = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?int
    {
        return $this->code;
    }

    public function setCode(?int $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TSubCounties[]
     */
    public function getTSubCounties(): Collection
    {
        return $this->tSubCounties;
    }

    public function addTSubCounties(TSubCounties $tSubCounties): self
    {
        if (!$this->tSubCounties->contains($tSubCounties)) {
            $this->tSubCounties[] = $tSubCounties;
            $tSubCounties->setCounty($this);
        }

        return $this;
    }

    public function removeTSubCounties(TSubCounties $tSubCounties): self
    {
        if ($this->tSubCounties->removeElement($tSubCounties)) {
            // set the owning side to null (unless already changed)
            if ($tSubCounties->getCounty() === $this) {
                $tSubCounties->setCounty(null);
            }
        }

        return $this;
    }
}
