<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TDiagnosisRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_diagnosis:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_diagnosis:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "status": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TDiagnosisRepository::class)
 */

class TDiagnosis
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_diagnosis:read", "t_diagnosis:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_diagnosis:read", "t_diagnosis:write"})
     */
    private $itemDescription;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_diagnosis:read", "t_diagnosis:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="diagnosis")
     * @Groups({"t_diagnosis:read", "t_diagnosis:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_diagnosis:read", "t_diagnosis:write"})
     */
    private $itemCode;

    /**
     * @ORM\ManyToOne(targetEntity=TDiagnosisCategories::class, inversedBy="tDiagnoses")
     * @Groups({"t_diagnosis:read", "t_diagnosis:write"})
     */
    private $diagnosisCategory;

    public function __construct()
    {
        $this->tTransactionsDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getItemDescription(): ?string
    {
        return $this->itemDescription;
    }

    public function setItemDescription(?string $itemDescription): self
    {
        $this->itemDescription = $itemDescription;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setDiagnosis($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getDiagnosis() === $this) {
                $tTransactionsDetail->setDiagnosis(null);
            }
        }

        return $this;
    }

    public function getItemCode(): ?string
    {
        return $this->itemCode;
    }

    public function setItemCode(?string $itemCode): self
    {
        $this->itemCode = $itemCode;

        return $this;
    }

    public function getDiagnosisCategory(): ?TDiagnosisCategories
    {
        return $this->diagnosisCategory;
    }

    public function setDiagnosisCategory(?TDiagnosisCategories $diagnosisCategory): self
    {
        $this->diagnosisCategory = $diagnosisCategory;

        return $this;
    }
}
