<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TDiagnosisCategoriesRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_diagnosis_categories:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_diagnosis_categories:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TDiagnosisCategoriesRepository::class)
 */

class TDiagnosisCategories
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_diagnosis_categories:read", "t_diagnosis_categories:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_diagnosis_categories:read", "t_diagnosis_categories:write", "t_diagnosis:read"})
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=TDiagnosis::class, mappedBy="diagnosisCategory")
     */
    private $tDiagnoses;

    public function __construct()
    {
        $this->tDiagnoses = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|TDiagnosis[]
     */
    public function getTDiagnoses(): Collection
    {
        return $this->tDiagnoses;
    }

    public function addTDiagnosis(TDiagnosis $tDiagnosis): self
    {
        if (!$this->tDiagnoses->contains($tDiagnosis)) {
            $this->tDiagnoses[] = $tDiagnosis;
            $tDiagnosis->setDiagnosisCategory($this);
        }

        return $this;
    }

    public function removeTDiagnosis(TDiagnosis $tDiagnosis): self
    {
        if ($this->tDiagnoses->removeElement($tDiagnosis)) {
            // set the owning side to null (unless already changed)
            if ($tDiagnosis->getDiagnosisCategory() === $this) {
                $tDiagnosis->setDiagnosisCategory(null);
            }
        }

        return $this;
    }
}
