<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TDosagesRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_dosages:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_dosages:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "status": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TDosagesRepository::class)
 */

class TDosages
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_dosages:read", "t_dosages:write", "t_transactions_details:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_dosages:read", "t_dosages:write"})
     */
    private $dosage1;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_dosages:read", "t_dosages:write"})
     */
    private $dosage2;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_dosages:read", "t_dosages:write", "t_transactions_details:read"})
     */
    private $dosageName;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_dosages:read", "t_dosages:write", "t_transactions_details:read"})
     */
    private $dosageRemarks;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_dosages:read", "t_dosages:write"})
     */
    private $note;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_dosages:read", "t_dosages:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="dosage")
     */
    private $tTransactionsDetails;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_dosages:read", "t_dosages:write", "t_transactions_details:read"})
     */
    private $dosageRoute;

    public function __construct()
    {
        $this->tTransactionsDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDosage1(): ?string
    {
        return $this->dosage1;
    }

    public function setDosage1(?string $dosage1): self
    {
        $this->dosage1 = $dosage1;

        return $this;
    }

    public function getDosage2(): ?string
    {
        return $this->dosage2;
    }

    public function setDosage2(?string $dosage2): self
    {
        $this->dosage2 = $dosage2;

        return $this;
    }

    public function getDosageName(): ?string
    {
        return $this->dosageName;
    }

    public function setDosageName(?string $dosageName): self
    {
        $this->dosageName = $dosageName;

        return $this;
    }

    public function getDosageRemarks(): ?string
    {
        return $this->dosageRemarks;
    }

    public function setDosageRemarks(?string $dosageRemarks): self
    {
        $this->dosageRemarks = $dosageRemarks;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setDosage($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getDosage() === $this) {
                $tTransactionsDetail->setDosage(null);
            }
        }

        return $this;
    }

    public function getDosageRoute(): ?string
    {
        return $this->dosageRoute;
    }

    public function setDosageRoute(?string $dosageRoute): self
    {
        $this->dosageRoute = $dosageRoute;

        return $this;
    }
}
