<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;

use Doctrine\ORM\Mapping as ORM;

use App\Repository\TFinancialYearsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_financial_years:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_financial_years:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TFinancialYearsRepository::class)
 */


class TFinancialYears
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_financial_years:read", "t_financial_years:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_financial_years:read", "t_financial_years:write"})
     */
    private $yearName;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_financial_years:read", "t_financial_years:write"})
     */
    private $startDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_financial_years:read", "t_financial_years:write"})
     */
    private $endDate;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_financial_years:read", "t_financial_years:write"})
     */
    private $defaultYear;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_financial_years:read", "t_financial_years:write"})
     */
    private $status;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getYearName(): ?string
    {
        return $this->yearName;
    }

    public function setYearName(?string $yearName): self
    {
        $this->yearName = $yearName;

        return $this;
    }

    public function getStartDate(): ?\DateTimeInterface
    {
        return $this->startDate;
    }

    public function setStartDate(?\DateTimeInterface $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?\DateTimeInterface
    {
        return $this->endDate;
    }

    public function setEndDate(?\DateTimeInterface $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }

    public function getDefaultYear(): ?string
    {
        return $this->defaultYear;
    }

    public function setDefaultYear(?string $defaultYear): self
    {
        $this->defaultYear = $defaultYear;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }
}
