<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use App\Repository\TGroupsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_groups:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_groups:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "type": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TGroupsRepository::class)
 */
class TGroups
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_groups:read", "t_groups:write", "t_stages_accesses:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     * @Groups({ "t_groups:read", "t_groups:write", "t_stages_accesses:read" })
     */
    private $groupName;

    /**
     * @ORM\Column(type="string", length=255)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $status;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $type;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainDashboard;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardHome;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardGraphical;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewStore;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $storeInventoryCategories;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $storeInventory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $inventoryAdditions;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $inventoryWithdrawals;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $inventoryHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewPurchases;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $purchasesNew;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $purchasesCreditNotes;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $purchasesHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewRegistration;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $registration;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $outPatientActivities;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $inPatientActivities;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewFinancials;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $invoices;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $payments;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewReports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewBackOffice;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewSetUp;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewSecurity;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $viewSettings;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainExpenses;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $expensesNew;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $expensesCreditNote;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $expensesHistory;

    /**
     * @ORM\OneToMany(targetEntity=TStagesAccess::class, mappedBy="accessGroup")
     */
    private $tStagesAccesses;

    public function __construct()
    {
        $this->tStagesAccesses = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getGroupName(): ?string
    {
        return $this->groupName;
    }

    public function setGroupName(string $groupName): self
    {
        $this->groupName = $groupName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getMainDashboard(): ?bool
    {
        return $this->mainDashboard;
    }

    public function setMainDashboard(?bool $mainDashboard): self
    {
        $this->mainDashboard = $mainDashboard;

        return $this;
    }

    public function getDashboardHome(): ?bool
    {
        return $this->dashboardHome;
    }

    public function setDashboardHome(?bool $dashboardHome): self
    {
        $this->dashboardHome = $dashboardHome;

        return $this;
    }

    public function getDashboardGraphical(): ?bool
    {
        return $this->dashboardGraphical;
    }

    public function setDashboardGraphical(?bool $dashboardGraphical): self
    {
        $this->dashboardGraphical = $dashboardGraphical;

        return $this;
    }

    public function getViewStore(): ?bool
    {
        return $this->viewStore;
    }

    public function setViewStore(?bool $viewStore): self
    {
        $this->viewStore = $viewStore;

        return $this;
    }

    public function getStoreInventoryCategories(): ?bool
    {
        return $this->storeInventoryCategories;
    }

    public function setStoreInventoryCategories(?bool $storeInventoryCategories): self
    {
        $this->storeInventoryCategories = $storeInventoryCategories;

        return $this;
    }

    public function getStoreInventory(): ?bool
    {
        return $this->storeInventory;
    }

    public function setStoreInventory(?bool $storeInventory): self
    {
        $this->storeInventory = $storeInventory;

        return $this;
    }

    public function getInventoryAdditions(): ?bool
    {
        return $this->inventoryAdditions;
    }

    public function setInventoryAdditions(?bool $inventoryAdditions): self
    {
        $this->inventoryAdditions = $inventoryAdditions;

        return $this;
    }

    public function getInventoryWithdrawals(): ?bool
    {
        return $this->inventoryWithdrawals;
    }

    public function setInventoryWithdrawals(?bool $inventoryWithdrawals): self
    {
        $this->inventoryWithdrawals = $inventoryWithdrawals;

        return $this;
    }

    public function getInventoryHistory(): ?bool
    {
        return $this->inventoryHistory;
    }

    public function setInventoryHistory(?bool $inventoryHistory): self
    {
        $this->inventoryHistory = $inventoryHistory;

        return $this;
    }

    public function getViewPurchases(): ?bool
    {
        return $this->viewPurchases;
    }

    public function setViewPurchases(?bool $viewPurchases): self
    {
        $this->viewPurchases = $viewPurchases;

        return $this;
    }

    public function getPurchasesNew(): ?bool
    {
        return $this->purchasesNew;
    }

    public function setPurchasesNew(?bool $purchasesNew): self
    {
        $this->purchasesNew = $purchasesNew;

        return $this;
    }

    public function getPurchasesCreditNotes(): ?bool
    {
        return $this->purchasesCreditNotes;
    }

    public function setPurchasesCreditNotes(?bool $purchasesCreditNotes): self
    {
        $this->purchasesCreditNotes = $purchasesCreditNotes;

        return $this;
    }

    public function getPurchasesHistory(): ?bool
    {
        return $this->purchasesHistory;
    }

    public function setPurchasesHistory(?bool $purchasesHistory): self
    {
        $this->purchasesHistory = $purchasesHistory;

        return $this;
    }

    public function getViewRegistration(): ?bool
    {
        return $this->viewRegistration;
    }

    public function setViewRegistration(?bool $viewRegistration): self
    {
        $this->viewRegistration = $viewRegistration;

        return $this;
    }

    public function getRegistration(): ?bool
    {
        return $this->registration;
    }

    public function setRegistration(?bool $registration): self
    {
        $this->registration = $registration;

        return $this;
    }

    public function getOutPatientActivities(): ?bool
    {
        return $this->outPatientActivities;
    }

    public function setOutPatientActivities(?bool $outPatientActivities): self
    {
        $this->outPatientActivities = $outPatientActivities;

        return $this;
    }

    public function getInPatientActivities(): ?bool
    {
        return $this->inPatientActivities;
    }

    public function setInPatientActivities(?bool $inPatientActivities): self
    {
        $this->inPatientActivities = $inPatientActivities;

        return $this;
    }

    public function getViewFinancials(): ?bool
    {
        return $this->viewFinancials;
    }

    public function setViewFinancials(?bool $viewFinancials): self
    {
        $this->viewFinancials = $viewFinancials;

        return $this;
    }

    public function getInvoices(): ?bool
    {
        return $this->invoices;
    }

    public function setInvoices(?bool $invoices): self
    {
        $this->invoices = $invoices;

        return $this;
    }

    public function getPayments(): ?bool
    {
        return $this->payments;
    }

    public function setPayments(?bool $payments): self
    {
        $this->payments = $payments;

        return $this;
    }

    public function getViewReports(): ?bool
    {
        return $this->viewReports;
    }

    public function setViewReports(?bool $viewReports): self
    {
        $this->viewReports = $viewReports;

        return $this;
    }

    public function getViewBackOffice(): ?bool
    {
        return $this->viewBackOffice;
    }

    public function setViewBackOffice(?bool $viewBackOffice): self
    {
        $this->viewBackOffice = $viewBackOffice;

        return $this;
    }

    public function getViewSetUp(): ?bool
    {
        return $this->viewSetUp;
    }

    public function setViewSetUp(?bool $viewSetUp): self
    {
        $this->viewSetUp = $viewSetUp;

        return $this;
    }

    public function getViewSecurity(): ?bool
    {
        return $this->viewSecurity;
    }

    public function setViewSecurity(?bool $viewSecurity): self
    {
        $this->viewSecurity = $viewSecurity;

        return $this;
    }

    public function getViewSettings(): ?bool
    {
        return $this->viewSettings;
    }

    public function setViewSettings(?bool $viewSettings): self
    {
        $this->viewSettings = $viewSettings;

        return $this;
    }

    public function getMainExpenses(): ?bool
    {
        return $this->mainExpenses;
    }

    public function setMainExpenses(?bool $mainExpenses): self
    {
        $this->mainExpenses = $mainExpenses;

        return $this;
    }

    public function getExpensesNew(): ?bool
    {
        return $this->expensesNew;
    }

    public function setExpensesNew(?bool $expensesNew): self
    {
        $this->expensesNew = $expensesNew;

        return $this;
    }

    public function getExpensesCreditNote(): ?bool
    {
        return $this->expensesCreditNote;
    }

    public function setExpensesCreditNote(?bool $expensesCreditNote): self
    {
        $this->expensesCreditNote = $expensesCreditNote;

        return $this;
    }

    public function getExpensesHistory(): ?bool
    {
        return $this->expensesHistory;
    }

    public function setExpensesHistory(?bool $expensesHistory): self
    {
        $this->expensesHistory = $expensesHistory;

        return $this;
    }

    /**
     * @return Collection|TStagesAccess[]
     */
    public function getTStagesAccesses(): Collection
    {
        return $this->tStagesAccesses;
    }

    public function addTStagesAccess(TStagesAccess $tStagesAccess): self
    {
        if (!$this->tStagesAccesses->contains($tStagesAccess)) {
            $this->tStagesAccesses[] = $tStagesAccess;
            $tStagesAccess->setAccessGroup($this);
        }

        return $this;
    }

    public function removeTStagesAccess(TStagesAccess $tStagesAccess): self
    {
        if ($this->tStagesAccesses->removeElement($tStagesAccess)) {
            // set the owning side to null (unless already changed)
            if ($tStagesAccess->getAccessGroup() === $this) {
                $tStagesAccess->setAccessGroup(null);
            }
        }

        return $this;
    }

}
