<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TInventoryRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_inventory:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_inventory:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "itemType": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TInventoryRepository::class)
 */

class TInventory
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_inventory:read", "t_inventory:write", "t_invoices:read", "t_transactions_details:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write", "t_invoices:read", "t_transactions_details:read", "t_accounts_transactions:read"})
     */
    private $itemDescription;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $itemType;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $location;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $reOrderLevel;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $cost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $profitMargin;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $price;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TServicesDetails::class, mappedBy="inventory")
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $tServicesDetails;

    /**
     * @ORM\ManyToOne(targetEntity=TInventoryCategories::class, inversedBy="tInventories")
     * @Groups({"t_inventory:read", "t_inventory:write", "t_invoices:read", "t_transactions_details:read"})
     */
    private $category;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $quantity;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="item")
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetailsTemps::class, mappedBy="item")
     */
    private $tTransactionsDetailsTemps;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="item")
     */
    private $tInvoices;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $billable;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="item")
     */
    private $tAccountsTransactions;

    /**
     * @ORM\OneToMany(targetEntity=TUnfullfilledPrescriptions::class, mappedBy="item")
     */
    private $tUnfullfilledPrescriptions;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tInventories")
     * @Groups({"t_inventory:read", "t_inventory:write"})
     */
    private $user;

    public function __construct()
    {
        $this->tServicesDetails = new ArrayCollection();
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tTransactionsDetailsTemps = new ArrayCollection();
        $this->tInvoices = new ArrayCollection();
        $this->tAccountsTransactions = new ArrayCollection();
        $this->tUnfullfilledPrescriptions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getItemDescription(): ?string
    {
        return $this->itemDescription;
    }

    public function setItemDescription(?string $itemDescription): self
    {
        $this->itemDescription = $itemDescription;

        return $this;
    }

    public function getItemType(): ?string
    {
        return $this->itemType;
    }

    public function setItemType(?string $itemType): self
    {
        $this->itemType = $itemType;

        return $this;
    }

    public function getLocation(): ?string
    {
        return $this->location;
    }

    public function setLocation(?string $location): self
    {
        $this->location = $location;

        return $this;
    }

    public function getReOrderLevel(): ?int
    {
        return $this->reOrderLevel;
    }

    public function setReOrderLevel(?int $reOrderLevel): self
    {
        $this->reOrderLevel = $reOrderLevel;

        return $this;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getProfitMargin(): ?string
    {
        return $this->profitMargin;
    }

    public function setProfitMargin(?string $profitMargin): self
    {
        $this->profitMargin = $profitMargin;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TServicesDetails[]
     */
    public function getTServicesDetails(): Collection
    {
        return $this->tServicesDetails;
    }

    public function addTServicesDetail(TServicesDetails $tServicesDetail): self
    {
        if (!$this->tServicesDetails->contains($tServicesDetail)) {
            $this->tServicesDetails[] = $tServicesDetail;
            $tServicesDetail->setInventory($this);
        }

        return $this;
    }

    public function removeTServicesDetail(TServicesDetails $tServicesDetail): self
    {
        if ($this->tServicesDetails->removeElement($tServicesDetail)) {
            // set the owning side to null (unless already changed)
            if ($tServicesDetail->getInventory() === $this) {
                $tServicesDetail->setInventory(null);
            }
        }

        return $this;
    }

    public function getCategory(): ?TInventoryCategories
    {
        return $this->category;
    }

    public function setCategory(?TInventoryCategories $category): self
    {
        $this->category = $category;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setItem($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getItem() === $this) {
                $tTransactionsDetail->setItem(null);
            }
        }

        return $this;
    }

    /**
     *  @Groups({"t_inventory:read"})
     */
    public function getTotalQuantity(){
        $total = 0;
        foreach($this->getTTransactionsDetails() as $detail){
            $total += $detail->getQuantity();
        }
        return $total;
    }

    /**
     * @return Collection|TTransactionsDetailsTemps[]
     */
    public function getTTransactionsDetailsTemps(): Collection
    {
        return $this->tTransactionsDetailsTemps;
    }

    public function addTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if (!$this->tTransactionsDetailsTemps->contains($tTransactionsDetailsTemp)) {
            $this->tTransactionsDetailsTemps[] = $tTransactionsDetailsTemp;
            $tTransactionsDetailsTemp->setItem($this);
        }

        return $this;
    }

    public function removeTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if ($this->tTransactionsDetailsTemps->removeElement($tTransactionsDetailsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetailsTemp->getItem() === $this) {
                $tTransactionsDetailsTemp->setItem(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setItem($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getItem() === $this) {
                $tInvoice->setItem(null);
            }
        }

        return $this;
    }

    public function getBillable(): ?string
    {
        return $this->billable;
    }

    public function setBillable(?string $billable): self
    {
        $this->billable = $billable;

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransaction(TAccountsTransactions $tAccountsTransaction): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransaction)) {
            $this->tAccountsTransactions[] = $tAccountsTransaction;
            $tAccountsTransaction->setItem($this);
        }

        return $this;
    }

    public function removeTAccountsTransaction(TAccountsTransactions $tAccountsTransaction): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransaction)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransaction->getItem() === $this) {
                $tAccountsTransaction->setItem(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TUnfullfilledPrescriptions[]
     */
    public function getTUnfullfilledPrescriptions(): Collection
    {
        return $this->tUnfullfilledPrescriptions;
    }

    public function addTUnfullfilledPrescription(TUnfullfilledPrescriptions $tUnfullfilledPrescription): self
    {
        if (!$this->tUnfullfilledPrescriptions->contains($tUnfullfilledPrescription)) {
            $this->tUnfullfilledPrescriptions[] = $tUnfullfilledPrescription;
            $tUnfullfilledPrescription->setItem($this);
        }

        return $this;
    }

    public function removeTUnfullfilledPrescription(TUnfullfilledPrescriptions $tUnfullfilledPrescription): self
    {
        if ($this->tUnfullfilledPrescriptions->removeElement($tUnfullfilledPrescription)) {
            // set the owning side to null (unless already changed)
            if ($tUnfullfilledPrescription->getItem() === $this) {
                $tUnfullfilledPrescription->setItem(null);
            }
        }

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }


}
