<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TInventoryCategoriesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_inventory_categories:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_inventory_categories:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TInventoryCategoriesRepository::class)
 */

class TInventoryCategories
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_inventory_categories:read", "t_inventory_categories:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_inventory_categories:read", "t_inventory_categories:write", "t_inventory:read"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_inventory_categories:read", "t_inventory_categories:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TInventory::class, mappedBy="category")
     */
    private $tInventories;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tInventoryCategories")
     * @Groups({"t_inventory_categories:read", "t_inventory_categories:write", "t_inventory:read", "t_invoices:read", "t_transactions_details:read"})
     */
    private $coa;

    public function __construct()
    {
        $this->tInventories = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TInventory[]
     */
    public function getTInventories(): Collection
    {
        return $this->tInventories;
    }

    public function addTInventory(TInventory $tInventory): self
    {
        if (!$this->tInventories->contains($tInventory)) {
            $this->tInventories[] = $tInventory;
            $tInventory->setCategory($this);
        }

        return $this;
    }

    public function removeTInventory(TInventory $tInventory): self
    {
        if ($this->tInventories->removeElement($tInventory)) {
            // set the owning side to null (unless already changed)
            if ($tInventory->getCategory() === $this) {
                $tInventory->setCategory(null);
            }
        }

        return $this;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }
}
