<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TInvoicesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\RangeFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_invoices:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_invoices:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "account": "exact", "transactionsDetails": "exact", "invoiceDate": "exact", "status": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(DateFilter::class, properties={"invoiceDate"})
 * @ApiFilter(RangeFilter::class, properties={"invoiceDate"})
 * @ORM\Entity(repositoryClass=TInvoicesRepository::class)
 */

class TInvoices
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TQueManager::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $que;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $stage;

    /**
     * @ORM\ManyToOne(targetEntity=TServiceFees::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $services;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $user;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $invoiceDate;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $totalAmount;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TPayments::class, mappedBy="invoice")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $tPayments;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="invoice")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $tAccountsTransactionss;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $month;

    /**
     * @ORM\ManyToOne(targetEntity=TTransactionsDetails::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $transactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactionsTemp::class, mappedBy="invoice")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $tAccountsTransactionsTemps;

    /**
     * @ORM\ManyToOne(targetEntity=TTransactionsDetailsTemps::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $transactionsDetailsTemps;

    /**
     * @ORM\ManyToOne(targetEntity=TInventory::class, inversedBy="tInvoices")
     * @Groups({"t_invoices:read", "t_invoices:write"})
     */
    private $item;

    public function __construct()
    {
        $this->tPayments = new ArrayCollection();
        $this->tAccountsTransactionss = new ArrayCollection();
        $this->tAccountsTransactionsTemps = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getQue(): ?TQueManager
    {
        return $this->que;
    }

    public function setQue(?TQueManager $que): self
    {
        $this->que = $que;

        return $this;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getServices(): ?TServiceFees
    {
        return $this->services;
    }

    public function setServices(?TServiceFees $services): self
    {
        $this->services = $services;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getInvoiceDate(): ?\DateTimeInterface
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?\DateTimeInterface $invoiceDate): self
    {
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getTotalAmount(): ?string
    {
        return $this->totalAmount;
    }

    public function setTotalAmount(?string $totalAmount): self
    {
        $this->totalAmount = $totalAmount;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TPayments[]
     */
    public function getTPayments(): Collection
    {
        return $this->tPayments;
    }

    public function addTPayments(TPayments $tPayments): self
    {
        if (!$this->tPayments->contains($tPayments)) {
            $this->tPayments[] = $tPayments;
            $tPayments->setInvoice($this);
        }

        return $this;
    }

    public function removeTPayments(TPayments $tPayments): self
    {
        if ($this->tPayments->removeElement($tPayments)) {
            // set the owning side to null (unless already changed)
            if ($tPayments->getInvoice() === $this) {
                $tPayments->setInvoice(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactionss(): Collection
    {
        return $this->tAccountsTransactionss;
    }

    public function addTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if (!$this->tAccountsTransactionss->contains($tAccountsTransactions)) {
            $this->tAccountsTransactionss[] = $tAccountsTransactions;
            $tAccountsTransactions->setInvoice($this);
        }

        return $this;
    }

    public function removeTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if ($this->tAccountsTransactionss->removeElement($tAccountsTransactions)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactions->getInvoice() === $this) {
                $tAccountsTransactions->setInvoice(null);
            }
        }

        return $this;
    }

    public function getYear(): ?string
    {
        return $this->year;
    }

    public function setYear(string $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?string
    {
        return $this->month;
    }

    public function setMonth(?string $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getTransactionsDetails(): ?TTransactionsDetails
    {
        return $this->transactionsDetails;
    }

    public function setTransactionsDetails(?TTransactionsDetails $transactionsDetails): self
    {
        $this->transactionsDetails = $transactionsDetails;

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactionsTemp[]
     */
    public function getTAccountsTransactionsTemps(): Collection
    {
        return $this->tAccountsTransactionsTemps;
    }

    public function addTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if (!$this->tAccountsTransactionsTemps->contains($tAccountsTransactionsTemp)) {
            $this->tAccountsTransactionsTemps[] = $tAccountsTransactionsTemp;
            $tAccountsTransactionsTemp->setInvoice($this);
        }

        return $this;
    }

    public function removeTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if ($this->tAccountsTransactionsTemps->removeElement($tAccountsTransactionsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactionsTemp->getInvoice() === $this) {
                $tAccountsTransactionsTemp->setInvoice(null);
            }
        }

        return $this;
    }

    public function getTransactionsDetailsTemps(): ?TTransactionsDetailsTemps
    {
        return $this->transactionsDetailsTemps;
    }

    public function setTransactionsDetailsTemps(?TTransactionsDetailsTemps $transactionsDetailsTemps): self
    {
        $this->transactionsDetailsTemps = $transactionsDetailsTemps;

        return $this;
    }

    public function getItem(): ?TInventory
    {
        return $this->item;
    }

    public function setItem(?TInventory $item): self
    {
        $this->item = $item;

        return $this;
    }
}
