<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TNextstagesRepository;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_nextstages:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_nextstages:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TNextstagesRepository::class)
 */

class TNextstages
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_nextstages:read", "t_nextstages:write", "t_stages:read"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tNextstages")
     * @Groups({"t_nextstages:read", "t_nextstages:write"})
     */
    private $stage;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_nextstages:read", "t_nextstages:write"})
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tNextStagesTwo")
     * @Groups({"t_nextstages:read", "t_nextstages:write", "t_stages:read"})
     */
    private $nextStageTwo;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getNextStageTwo(): ?TStages
    {
        return $this->nextStageTwo;
    }

    public function setNextStageTwo(?TStages $nextStageTwo): self
    {
        $this->nextStageTwo = $nextStageTwo;

        return $this;
    }
}
