<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TOtherEarningsDeductionsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_other_earnings_deductions:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_other_earnings_deductions:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "month": "exact", "year": "exact", "salaryDefined": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TOtherEarningsDeductionsRepository::class)
 */

class TOtherEarningsDeductions
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $type;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $amount;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $status;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $dueDate;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $month;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tOtherEarningsDeductions")
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tOtherEarningsDeductions")
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $coa;

    /**
     * @ORM\ManyToOne(targetEntity=TSalariesDefined::class, inversedBy="tOtherEarningsDeductions")
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $salaryDefined;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_other_earnings_deductions:read", "t_other_earnings_deductions:write"})
     */
    private $itemDescription;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="otherEarningsAndDeductions")
     */
    private $tTransactionsDetails;

    public function __construct()
    {
        $this->tTransactionsDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getDueDate(): ?\DateTimeInterface
    {
        return $this->dueDate;
    }

    public function setDueDate(?\DateTimeInterface $dueDate): self
    {
        $this->dueDate = $dueDate;

        return $this;
    }

    public function getYear(): ?int
    {
        return $this->year;
    }

    public function setYear(?int $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?string
    {
        return $this->month;
    }

    public function setMonth(?string $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    public function getSalaryDefined(): ?TSalariesDefined
    {
        return $this->salaryDefined;
    }

    public function setSalaryDefined(?TSalariesDefined $salaryDefined): self
    {
        $this->salaryDefined = $salaryDefined;

        return $this;
    }

    public function getItemDescription(): ?string
    {
        return $this->itemDescription;
    }

    public function setItemDescription(?string $itemDescription): self
    {
        $this->itemDescription = $itemDescription;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setOtherEarningsAndDeductions($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getOtherEarningsAndDeductions() === $this) {
                $tTransactionsDetail->setOtherEarningsAndDeductions(null);
            }
        }

        return $this;
    }
}
