<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TPaymentsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\RangeFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_payments:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_payments:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "paymentDate": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(DateFilter::class, properties={"paymentDate"})
 * @ApiFilter(RangeFilter::class, properties={"paymentDate"})
 * @ORM\Entity(repositoryClass=TPaymentsRepository::class)
 */

class TPayments
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TInvoices::class, inversedBy="tPayments")
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $invoice;

    /**
     * @ORM\ManyToOne(targetEntity=TSponsors::class, inversedBy="tPayments")
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $sponsor;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tPayments")
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $coa;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $paymentDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $paymentType;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $transId;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $transTime;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $transAmount;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $businessShortCode;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $billRefNumber;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $invoiceNumber;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $orgAccountBalance;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $thirdPartyTransId;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $mSisdn;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $firstName;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $originalJson;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $paymentStatus;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $transDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $paymentTime;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="payment")
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $tAccountsTransactions;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $month;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tPayments")
     * @Groups({"t_payments:read", "t_payments:write"})
     */
    private $user;

    public function __construct()
    {
        $this->tAccountsTransactions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getInvoice(): ?TInvoices
    {
        return $this->invoice;
    }

    public function setInvoice(?TInvoices $invoice): self
    {
        $this->invoice = $invoice;

        return $this;
    }

    public function getSponsor(): ?TSponsors
    {
        return $this->sponsor;
    }

    public function setSponsor(?TSponsors $sponsor): self
    {
        $this->sponsor = $sponsor;

        return $this;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    public function getPaymentDate(): ?\DateTimeInterface
    {
        return $this->paymentDate;
    }

    public function setPaymentDate(?\DateTimeInterface $paymentDate): self
    {
        $this->paymentDate = $paymentDate;

        return $this;
    }

    public function getPaymentType(): ?string
    {
        return $this->paymentType;
    }

    public function setPaymentType(?string $paymentType): self
    {
        $this->paymentType = $paymentType;

        return $this;
    }

    public function getTransId(): ?int
    {
        return $this->transId;
    }

    public function setTransId(?int $transId): self
    {
        $this->transId = $transId;

        return $this;
    }

    public function getTransTime(): ?\DateTimeInterface
    {
        return $this->transTime;
    }

    public function setTransTime(?\DateTimeInterface $transTime): self
    {
        $this->transTime = $transTime;

        return $this;
    }

    public function getTransAmount(): ?string
    {
        return $this->transAmount;
    }

    public function setTransAmount(?string $transAmount): self
    {
        $this->transAmount = $transAmount;

        return $this;
    }

    public function getBusinessShortCode(): ?string
    {
        return $this->businessShortCode;
    }

    public function setBusinessShortCode(?string $businessShortCode): self
    {
        $this->businessShortCode = $businessShortCode;

        return $this;
    }

    public function getBillRefNumber(): ?string
    {
        return $this->billRefNumber;
    }

    public function setBillRefNumber(?string $billRefNumber): self
    {
        $this->billRefNumber = $billRefNumber;

        return $this;
    }

    public function getInvoiceNumber(): ?string
    {
        return $this->invoiceNumber;
    }

    public function setInvoiceNumber(?string $invoiceNumber): self
    {
        $this->invoiceNumber = $invoiceNumber;

        return $this;
    }

    public function getOrgAccountBalance(): ?string
    {
        return $this->orgAccountBalance;
    }

    public function setOrgAccountBalance(?string $orgAccountBalance): self
    {
        $this->orgAccountBalance = $orgAccountBalance;

        return $this;
    }

    public function getThirdPartyTransId(): ?int
    {
        return $this->thirdPartyTransId;
    }

    public function setThirdPartyTransId(?int $thirdPartyTransId): self
    {
        $this->thirdPartyTransId = $thirdPartyTransId;

        return $this;
    }

    public function getMSisdn(): ?string
    {
        return $this->mSisdn;
    }

    public function setMSisdn(?string $mSisdn): self
    {
        $this->mSisdn = $mSisdn;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getOriginalJson(): ?string
    {
        return $this->originalJson;
    }

    public function setOriginalJson(?string $originalJson): self
    {
        $this->originalJson = $originalJson;

        return $this;
    }

    public function getPaymentStatus(): ?string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(?string $paymentStatus): self
    {
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    public function getTransDate(): ?\DateTimeInterface
    {
        return $this->transDate;
    }

    public function setTransDate(?\DateTimeInterface $transDate): self
    {
        $this->transDate = $transDate;

        return $this;
    }

    public function getPaymentTime(): ?\DateTimeInterface
    {
        return $this->paymentTime;
    }

    public function setPaymentTime(?\DateTimeInterface $paymentTime): self
    {
        $this->paymentTime = $paymentTime;

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransactions)) {
            $this->tAccountsTransactions[] = $tAccountsTransactions;
            $tAccountsTransactions->setPayment($this);
        }

        return $this;
    }

    public function removeTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransactions)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactions->getPayment() === $this) {
                $tAccountsTransactions->setPayment(null);
            }
        }

        return $this;
    }

    public function getYear(): ?string
    {
        return $this->year;
    }

    public function setYear(?string $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?string
    {
        return $this->month;
    }

    public function setMonth(?string $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }
}
