<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TPayslipItemsRepository;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_payslip_items:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_payslip_items:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "salaryCategories": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TPayslipItemsRepository::class)
 */

class TPayslipItems
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $type;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $calculationType;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $status;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $amount;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tPayslipItems")
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $coa;

    /**
     * @ORM\ManyToOne(targetEntity=TSalaryCategories::class, inversedBy="tPayslipItems")
     * @Groups({"t_payslip_items:read", "t_payslip_items:write"})
     */
    private $salaryCategories;

    /**
     * @ORM\ManyToOne(targetEntity=TSalariesDefined::class, inversedBy="tPayslipItems")
     */
    private $salaryDefined;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="payslip")
     */
    private $tTransactionsDetails;

    public function __construct()
    {
        $this->tTransactionsDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getCalculationType(): ?string
    {
        return $this->calculationType;
    }

    public function setCalculationType(?string $calculationType): self
    {
        $this->calculationType = $calculationType;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    public function getSalaryCategories(): ?TSalaryCategories
    {
        return $this->salaryCategories;
    }

    public function setSalaryCategories(?TSalaryCategories $salaryCategories): self
    {
        $this->salaryCategories = $salaryCategories;

        return $this;
    }

    public function getSalaryDefined(): ?TSalariesDefined
    {
        return $this->salaryDefined;
    }

    public function setSalaryDefined(?TSalariesDefined $salaryDefined): self
    {
        $this->salaryDefined = $salaryDefined;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setPayslip($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getPayslip() === $this) {
                $tTransactionsDetail->setPayslip(null);
            }
        }

        return $this;
    }
}
