<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TPersonalizeRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_personalize:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_personalize:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TPersonalizeRepository::class)
 */

class TPersonalize
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_personalize:read", "t_personalize:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_personalize:read", "t_personalize:write"})
     */
    private $outPatientRegistrationStage;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_personalize:read", "t_personalize:write"})
     */
    private $outPatientWorkflow;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_personalize:read", "t_personalize:write"})
     */
    private $inPatientRegistrationStage;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_personalize:read", "t_personalize:write"})
     */
    private $inPatientWorkflow;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getOutPatientRegistrationStage(): ?int
    {
        return $this->outPatientRegistrationStage;
    }

    public function setOutPatientRegistrationStage(?int $outPatientRegistrationStage): self
    {
        $this->outPatientRegistrationStage = $outPatientRegistrationStage;

        return $this;
    }

    public function getOutPatientWorkflow(): ?int
    {
        return $this->outPatientWorkflow;
    }

    public function setOutPatientWorkflow(int $outPatientWorkflow): self
    {
        $this->outPatientWorkflow = $outPatientWorkflow;

        return $this;
    }

    public function getInPatientRegistrationStage(): ?int
    {
        return $this->inPatientRegistrationStage;
    }

    public function setInPatientRegistrationStage(?int $inPatientRegistrationStage): self
    {
        $this->inPatientRegistrationStage = $inPatientRegistrationStage;

        return $this;
    }

    public function getInPatientWorkflow(): ?int
    {
        return $this->inPatientWorkflow;
    }

    public function setInPatientWorkflow(?int $inPatientWorkflow): self
    {
        $this->inPatientWorkflow = $inPatientWorkflow;

        return $this;
    }
}
