<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TQueManagerRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_que_manager:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_que_manager:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "account": "exact", "status": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TQueManagerRepository::class)
 */

class TQueManager
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_que_manager:read", "t_que_manager:write", "t_all_accounts:read", "t_transactions_details:read", "t_invoices:read"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tQueManagers")
     * @Groups({"t_que_manager:read", "t_que_manager:write", "t_all_accounts:read"})
     */
    private $stage;

    /**
     * @ORM\OneToMany(targetEntity=TStagesTimelines::class, mappedBy="que")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $tStagesTimelines;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="que")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $tInvoices;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="que")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tQueManagers")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TWorkflows::class, inversedBy="tQueManagers")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $workflow;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $queDate;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="queManagersPrevStage")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $prevStage;

    /**
     * @ORM\Column(type="time", nullable=true)
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $queTime;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tQueManagers")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $queBy;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetailsTemps::class, mappedBy="que")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $tTransactionsDetailsTemps;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactionsTemp::class, mappedBy="que")
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $tAccountsTransactionsTemps;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="que")
     */
    private $tAccountsTransactions;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_que_manager:read", "t_que_manager:write"})
     */
    private $priority;

    public function __construct()
    {
        $this->tStagesTimelines = new ArrayCollection();
        $this->tInvoices = new ArrayCollection();
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tTransactionsDetailsTemps = new ArrayCollection();
        $this->tAccountsTransactionsTemps = new ArrayCollection();
        $this->tAccountsTransactions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    /**
     * @return Collection|TStagesTimelines[]
     */
    public function getTStagesTimelines(): Collection
    {
        return $this->tStagesTimelines;
    }

    public function addTStagesTimeline(TStagesTimelines $tStagesTimeline): self
    {
        if (!$this->tStagesTimelines->contains($tStagesTimeline)) {
            $this->tStagesTimelines[] = $tStagesTimeline;
            $tStagesTimeline->setQue($this);
        }

        return $this;
    }

    public function removeTStagesTimeline(TStagesTimelines $tStagesTimeline): self
    {
        if ($this->tStagesTimelines->removeElement($tStagesTimeline)) {
            // set the owning side to null (unless already changed)
            if ($tStagesTimeline->getQue() === $this) {
                $tStagesTimeline->setQue(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setQue($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getQue() === $this) {
                $tInvoice->setQue(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setQue($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getQue() === $this) {
                $tTransactionsDetail->setQue(null);
            }
        }

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getWorkflow(): ?TWorkflows
    {
        return $this->workflow;
    }

    public function setWorkflow(?TWorkflows $workflow): self
    {
        $this->workflow = $workflow;

        return $this;
    }

    public function getQueDate(): ?\DateTimeInterface
    {
        return $this->queDate;
    }

    public function setQueDate(?\DateTimeInterface $queDate): self
    {
        $this->queDate = $queDate;

        return $this;
    }

    public function getPrevStage(): ?TStages
    {
        return $this->prevStage;
    }

    public function setPrevStage(?TStages $prevStage): self
    {
        $this->prevStage = $prevStage;

        return $this;
    }

    public function getQueTime(): ?\DateTimeInterface
    {
        return $this->queTime;
    }

    public function setQueTime(?\DateTimeInterface $queTime): self
    {
        $this->queTime = $queTime;

        return $this;
    }

    public function getQueBy(): ?User
    {
        return $this->queBy;
    }

    public function setQueBy(?User $queBy): self
    {
        $this->queBy = $queBy;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetailsTemps[]
     */
    public function getTTransactionsDetailsTemps(): Collection
    {
        return $this->tTransactionsDetailsTemps;
    }

    public function addTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if (!$this->tTransactionsDetailsTemps->contains($tTransactionsDetailsTemp)) {
            $this->tTransactionsDetailsTemps[] = $tTransactionsDetailsTemp;
            $tTransactionsDetailsTemp->setQue($this);
        }

        return $this;
    }

    public function removeTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if ($this->tTransactionsDetailsTemps->removeElement($tTransactionsDetailsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetailsTemp->getQue() === $this) {
                $tTransactionsDetailsTemp->setQue(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactionsTemp[]
     */
    public function getTAccountsTransactionsTemps(): Collection
    {
        return $this->tAccountsTransactionsTemps;
    }

    public function addTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if (!$this->tAccountsTransactionsTemps->contains($tAccountsTransactionsTemp)) {
            $this->tAccountsTransactionsTemps[] = $tAccountsTransactionsTemp;
            $tAccountsTransactionsTemp->setQue($this);
        }

        return $this;
    }

    public function removeTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if ($this->tAccountsTransactionsTemps->removeElement($tAccountsTransactionsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactionsTemp->getQue() === $this) {
                $tAccountsTransactionsTemp->setQue(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransaction(TAccountsTransactions $tAccountsTransaction): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransaction)) {
            $this->tAccountsTransactions[] = $tAccountsTransaction;
            $tAccountsTransaction->setQue($this);
        }

        return $this;
    }

    public function removeTAccountsTransaction(TAccountsTransactions $tAccountsTransaction): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransaction)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransaction->getQue() === $this) {
                $tAccountsTransaction->setQue(null);
            }
        }

        return $this;
    }

    public function getPriority(): ?string
    {
        return $this->priority;
    }

    public function setPriority(?string $priority): self
    {
        $this->priority = $priority;

        return $this;
    }
}
