<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSalariesDefinedRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_salaries_defineds:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_salaries_defineds:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "status": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSalariesDefinedRepository::class)
 */

class TSalariesDefined
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write", "t_accounts_transactions_temp:read"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TSalaryCategories::class, inversedBy="tSalariesDefineds")
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write", "t_accounts_transactions_temp:read"})
     */
    private $salaryCat;

    /**
     * @ORM\ManyToOne(targetEntity=TStaffMembers::class, inversedBy="tSalariesDefineds")
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write", "t_accounts_transactions_temp:read", "t_salary_advances:read", "t_other_earnings_deductions:read"})
     */
    private $staffMember;

    /**
     * @ORM\OneToMany(targetEntity=TPayslipItems::class, mappedBy="salaryDefined")
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write"})
     */
    private $tPayslipItems;

    /**
     * @ORM\OneToMany(targetEntity=TOtherEarningsDeductions::class, mappedBy="salaryDefined")
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write"})
     */
    private $tOtherEarningsDeductions;

    /**
     * @ORM\OneToMany(targetEntity=TSalaryAdvances::class, mappedBy="salaryDefined")
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write"})
     */
    private $tSalaryAdvances;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactionsTemp::class, mappedBy="salaryDefined")
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write"})
     */
    private $tAccountsTransactionsTemps;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_salaries_defineds:read", "t_salaries_defineds:write"})
     */
    private $status;

    public function __construct()
    {
        $this->tPayslipItems = new ArrayCollection();
        $this->tOtherEarningsDeductions = new ArrayCollection();
        $this->tSalaryAdvances = new ArrayCollection();
        $this->tAccountsTransactionsTemps = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSalaryCat(): ?TSalaryCategories
    {
        return $this->salaryCat;
    }

    public function setSalaryCat(?TSalaryCategories $salaryCat): self
    {
        $this->salaryCat = $salaryCat;

        return $this;
    }

    public function getStaffMember(): ?TStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    /**
     * @return Collection|TPayslipItems[]
     */
    public function getTPayslipItems(): Collection
    {
        return $this->tPayslipItems;
    }

    public function addTPayslipItem(TPayslipItems $tPayslipItem): self
    {
        if (!$this->tPayslipItems->contains($tPayslipItem)) {
            $this->tPayslipItems[] = $tPayslipItem;
            $tPayslipItem->setSalaryDefined($this);
        }

        return $this;
    }

    public function removeTPayslipItem(TPayslipItems $tPayslipItem): self
    {
        if ($this->tPayslipItems->removeElement($tPayslipItem)) {
            // set the owning side to null (unless already changed)
            if ($tPayslipItem->getSalaryDefined() === $this) {
                $tPayslipItem->setSalaryDefined(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TOtherEarningsDeductions[]
     */
    public function getTOtherEarningsDeductions(): Collection
    {
        return $this->tOtherEarningsDeductions;
    }

    public function addTOtherEarningsDeduction(TOtherEarningsDeductions $tOtherEarningsDeduction): self
    {
        if (!$this->tOtherEarningsDeductions->contains($tOtherEarningsDeduction)) {
            $this->tOtherEarningsDeductions[] = $tOtherEarningsDeduction;
            $tOtherEarningsDeduction->setSalaryDefined($this);
        }

        return $this;
    }

    public function removeTOtherEarningsDeduction(TOtherEarningsDeductions $tOtherEarningsDeduction): self
    {
        if ($this->tOtherEarningsDeductions->removeElement($tOtherEarningsDeduction)) {
            // set the owning side to null (unless already changed)
            if ($tOtherEarningsDeduction->getSalaryDefined() === $this) {
                $tOtherEarningsDeduction->setSalaryDefined(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSalaryAdvances[]
     */
    public function getTSalaryAdvances(): Collection
    {
        return $this->tSalaryAdvances;
    }

    public function addTSalaryAdvance(TSalaryAdvances $tSalaryAdvance): self
    {
        if (!$this->tSalaryAdvances->contains($tSalaryAdvance)) {
            $this->tSalaryAdvances[] = $tSalaryAdvance;
            $tSalaryAdvance->setSalaryDefined($this);
        }

        return $this;
    }

    public function removeTSalaryAdvance(TSalaryAdvances $tSalaryAdvance): self
    {
        if ($this->tSalaryAdvances->removeElement($tSalaryAdvance)) {
            // set the owning side to null (unless already changed)
            if ($tSalaryAdvance->getSalaryDefined() === $this) {
                $tSalaryAdvance->setSalaryDefined(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactionsTemp[]
     */
    public function getTAccountsTransactionsTemps(): Collection
    {
        return $this->tAccountsTransactionsTemps;
    }

    public function addTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if (!$this->tAccountsTransactionsTemps->contains($tAccountsTransactionsTemp)) {
            $this->tAccountsTransactionsTemps[] = $tAccountsTransactionsTemp;
            $tAccountsTransactionsTemp->setSalaryDefined($this);
        }

        return $this;
    }

    public function removeTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if ($this->tAccountsTransactionsTemps->removeElement($tAccountsTransactionsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactionsTemp->getSalaryDefined() === $this) {
                $tAccountsTransactionsTemp->setSalaryDefined(null);
            }
        }

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }
}
