<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSalaryAdvancesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_salary_advances:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_salary_advances:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "month": "exact", "year": "exact", "salaryDefined": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSalaryAdvancesRepository::class)
 */

class TSalaryAdvances
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_salary_advances:read", "t_salary_advances:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_salary_advances:read", "t_salary_advances:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_salary_advances:read", "t_salary_advances:write"})
     */
    private $amount;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_salary_advances:read", "t_salary_advances:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_salary_advances:read", "t_salary_advances:write"})
     */
    private $month;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tSalaryAdvances")
     * @Groups({"t_salary_advances:read", "t_salary_advances:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TSalariesDefined::class, inversedBy="tSalaryAdvances")
     * @Groups({"t_salary_advances:read", "t_salary_advances:write"})
     */
    private $salaryDefined;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="salaryAdvance")
     */
    private $tTransactionsDetails;

    public function __construct()
    {
        $this->tTransactionsDetails = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getYear(): ?int
    {
        return $this->year;
    }

    public function setYear(?int $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?string
    {
        return $this->month;
    }

    public function setMonth(?string $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getSalaryDefined(): ?TSalariesDefined
    {
        return $this->salaryDefined;
    }

    public function setSalaryDefined(?TSalariesDefined $salaryDefined): self
    {
        $this->salaryDefined = $salaryDefined;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setSalaryAdvance($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getSalaryAdvance() === $this) {
                $tTransactionsDetail->setSalaryAdvance(null);
            }
        }

        return $this;
    }
}
