<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSalaryCategoriesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_salary_categories:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_salary_categories:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSalaryCategoriesRepository::class)
 */

class TSalaryCategories
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_salary_categories:read", "t_salary_categories:write", "t_salaries_defineds:read", "t_accounts_transactions_temp:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_salary_categories:read", "t_salary_categories:write", "t_payslip_items:read", "t_salaries_defineds:read", "t_accounts_transactions_temp:read"})
     */
    private $name;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_salary_categories:read", "t_salary_categories:write", "t_salaries_defineds:read"})
     */
    private $amount;

    /**
     * @ORM\OneToMany(targetEntity=TPayslipItems::class, mappedBy="salaryCategories")
     * @Groups({"t_salary_categories:read", "t_salary_categories:write"})
     */
    private $tPayslipItems;

    /**
     * @ORM\OneToMany(targetEntity=TSalariesDefined::class, mappedBy="salaryCat")
     */
    private $tSalariesDefineds;

    public function __construct()
    {
        $this->tPayslipItems = new ArrayCollection();
        $this->tSalariesDefineds = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * @return Collection|TPayslipItems[]
     */
    public function getTPayslipItems(): Collection
    {
        return $this->tPayslipItems;
    }

    public function addTPayslipItem(TPayslipItems $tPayslipItem): self
    {
        if (!$this->tPayslipItems->contains($tPayslipItem)) {
            $this->tPayslipItems[] = $tPayslipItem;
            $tPayslipItem->setSalaryCategories($this);
        }

        return $this;
    }

    public function removeTPayslipItem(TPayslipItems $tPayslipItem): self
    {
        if ($this->tPayslipItems->removeElement($tPayslipItem)) {
            // set the owning side to null (unless already changed)
            if ($tPayslipItem->getSalaryCategories() === $this) {
                $tPayslipItem->setSalaryCategories(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSalariesDefined[]
     */
    public function getTSalariesDefineds(): Collection
    {
        return $this->tSalariesDefineds;
    }

    public function addTSalariesDefined(TSalariesDefined $tSalariesDefined): self
    {
        if (!$this->tSalariesDefineds->contains($tSalariesDefined)) {
            $this->tSalariesDefineds[] = $tSalariesDefined;
            $tSalariesDefined->setSalaryCat($this);
        }

        return $this;
    }

    public function removeTSalariesDefined(TSalariesDefined $tSalariesDefined): self
    {
        if ($this->tSalariesDefineds->removeElement($tSalariesDefined)) {
            // set the owning side to null (unless already changed)
            if ($tSalariesDefined->getSalaryCat() === $this) {
                $tSalariesDefined->setSalaryCat(null);
            }
        }

        return $this;
    }
}
