<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TServiceFeesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_service_fees:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_service_fees:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "serviceType": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TServiceFeesRepository::class)
 */

class TServiceFees
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_service_fees:read", "t_service_fees:write", "t_transactions_details:read", "t_invoices:read"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tServiceFees")
     * @Groups({"t_service_fees:read", "t_service_fees:write", "t_invoices:read"})
     */
    private $coa;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tServiceFees")
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $stage;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_service_fees:read", "t_service_fees:write", "t_invoices:read", "t_transactions_details:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $cost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $profitMargin;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $price;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="services")
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $tInvoices;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="service")
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $tAccountsTransactions;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="services")
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TServicesDetails::class, mappedBy="service")
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $tServicesDetails;

    /**
     * @ORM\ManyToOne(targetEntity=TServicesCategories::class, inversedBy="tServiceFees")
     * @Groups({"t_service_fees:read", "t_service_fees:write", "t_transactions_details:read"})
     */
    private $servicesCategories;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $serviceType;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $billable;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetailsTemps::class, mappedBy="services")
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $tTransactionsDetailsTemps;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactionsTemp::class, mappedBy="service")
     * @Groups({"t_service_fees:read", "t_service_fees:write"})
     */
    private $tAccountsTransactionsTemps;

    public function __construct()
    {
        $this->tInvoices = new ArrayCollection();
        $this->tAccountsTransactions = new ArrayCollection();
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tServicesDetails = new ArrayCollection();
        $this->tTransactionsDetailsTemps = new ArrayCollection();
        $this->tAccountsTransactionsTemps = new ArrayCollection();
    }

     /**
     *  @Groups({"t_service_fees:read"})
     */
    public function getTotalCost(){
        $total = 0;
        foreach($this->getTServicesDetails() as $detail){
            $total += $detail->getTotalCost();
        }
        return $total;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getProfitMargin(): ?string
    {
        return $this->profitMargin;
    }

    public function setProfitMargin(?string $profitMargin): self
    {
        $this->profitMargin = $profitMargin;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setServices($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getServices() === $this) {
                $tInvoice->setServices(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransactions)) {
            $this->tAccountsTransactions[] = $tAccountsTransactions;
            $tAccountsTransactions->setService($this);
        }

        return $this;
    }

    public function removeTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransactions)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactions->getService() === $this) {
                $tAccountsTransactions->setService(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setServices($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getServices() === $this) {
                $tTransactionsDetail->setServices(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TServicesDetails[]
     */
    public function getTServicesDetails(): Collection
    {
        return $this->tServicesDetails;
    }

    public function addTServicesDetail(TServicesDetails $tServicesDetail): self
    {
        if (!$this->tServicesDetails->contains($tServicesDetail)) {
            $this->tServicesDetails[] = $tServicesDetail;
            $tServicesDetail->setService($this);
        }

        return $this;
    }

    public function removeTServicesDetail(TServicesDetails $tServicesDetail): self
    {
        if ($this->tServicesDetails->removeElement($tServicesDetail)) {
            // set the owning side to null (unless already changed)
            if ($tServicesDetail->getService() === $this) {
                $tServicesDetail->setService(null);
            }
        }

        return $this;
    }

    public function getServicesCategories(): ?TServicesCategories
    {
        return $this->servicesCategories;
    }

    public function setServicesCategories(?TServicesCategories $servicesCategories): self
    {
        $this->servicesCategories = $servicesCategories;

        return $this;
    }

    public function getServiceType(): ?string
    {
        return $this->serviceType;
    }

    public function setServiceType(?string $serviceType): self
    {
        $this->serviceType = $serviceType;

        return $this;
    }

    public function getBillable(): ?string
    {
        return $this->billable;
    }

    public function setBillable(?string $billable): self
    {
        $this->billable = $billable;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetailsTemps[]
     */
    public function getTTransactionsDetailsTemps(): Collection
    {
        return $this->tTransactionsDetailsTemps;
    }

    public function addTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if (!$this->tTransactionsDetailsTemps->contains($tTransactionsDetailsTemp)) {
            $this->tTransactionsDetailsTemps[] = $tTransactionsDetailsTemp;
            $tTransactionsDetailsTemp->setServices($this);
        }

        return $this;
    }

    public function removeTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if ($this->tTransactionsDetailsTemps->removeElement($tTransactionsDetailsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetailsTemp->getServices() === $this) {
                $tTransactionsDetailsTemp->setServices(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactionsTemp[]
     */
    public function getTAccountsTransactionsTemps(): Collection
    {
        return $this->tAccountsTransactionsTemps;
    }

    public function addTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if (!$this->tAccountsTransactionsTemps->contains($tAccountsTransactionsTemp)) {
            $this->tAccountsTransactionsTemps[] = $tAccountsTransactionsTemp;
            $tAccountsTransactionsTemp->setService($this);
        }

        return $this;
    }

    public function removeTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if ($this->tAccountsTransactionsTemps->removeElement($tAccountsTransactionsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactionsTemp->getService() === $this) {
                $tAccountsTransactionsTemp->setService(null);
            }
        }

        return $this;
    }
}
