<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TServicesCategoriesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_services_categories:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_services_categories:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TServicesCategoriesRepository::class)
 */

class TServicesCategories
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_services_categories:read", "t_services_categories:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_services_categories:read", "t_services_categories:write"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_services_categories:read", "t_services_categories:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TServiceFees::class, mappedBy="servicesCategories")
     * @Groups({"t_services_categories:read", "t_services_categories:write"})
     */
    private $tServiceFees;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tServicesCategories")
     * @Groups({"t_services_categories:read", "t_services_categories:write", "t_transactions_details:read"})
     */
    private $inventoryCoa;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tServicesCategories")
     * @Groups({"t_services_categories:read", "t_services_categories:write", "t_transactions_details:read"})
     */
    private $costOfGoodSold;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tServicesCategories")
     * @Groups({"t_services_categories:read", "t_services_categories:write", "t_transactions_details:read"})
     */
    private $salesCoa;

    public function __construct()
    {
        $this->tServiceFees = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TServiceFees[]
     */
    public function getTServiceFees(): Collection
    {
        return $this->tServiceFees;
    }

    public function addTServiceFee(TServiceFees $tServiceFee): self
    {
        if (!$this->tServiceFees->contains($tServiceFee)) {
            $this->tServiceFees[] = $tServiceFee;
            $tServiceFee->setServicesCategories($this);
        }

        return $this;
    }

    public function removeTServiceFee(TServiceFees $tServiceFee): self
    {
        if ($this->tServiceFees->removeElement($tServiceFee)) {
            // set the owning side to null (unless already changed)
            if ($tServiceFee->getServicesCategories() === $this) {
                $tServiceFee->setServicesCategories(null);
            }
        }

        return $this;
    }

    public function getInventoryCoa(): ?TCoas
    {
        return $this->inventoryCoa;
    }

    public function setInventoryCoa(?TCoas $inventoryCoa): self
    {
        $this->inventoryCoa = $inventoryCoa;

        return $this;
    }

    public function getCostOfGoodSold(): ?TCoas
    {
        return $this->costOfGoodSold;
    }

    public function setCostOfGoodSold(?TCoas $costOfGoodSold): self
    {
        $this->costOfGoodSold = $costOfGoodSold;

        return $this;
    }

    public function getSalesCoa(): ?TCoas
    {
        return $this->salesCoa;
    }

    public function setSalesCoa(?TCoas $salesCoa): self
    {
        $this->salesCoa = $salesCoa;

        return $this;
    }

}
