<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TServicesDetailsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_services_details:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_services_details:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "serviceType": "exact", "service": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TServicesDetailsRepository::class)
 */

class TServicesDetails
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TServiceFees::class, inversedBy="tServicesDetails")
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $service;

    /**
     * @ORM\ManyToOne(targetEntity=TInventory::class, inversedBy="tServicesDetails")
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $inventory;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $subItemType;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $subItemDescription;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $subItemQty;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $serviceCost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $servicePrice;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity=TStaffMembers::class, inversedBy="tServicesDetails")
     * @Groups({"t_services_details:read", "t_services_details:write" })
     */
    private $staff;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_services_details:read", "t_services_details:write"})
     */
    private $totalCost;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getService(): ?TServiceFees
    {
        return $this->service;
    }

    public function setService(?TServiceFees $service): self
    {
        $this->service = $service;

        return $this;
    }

    public function getInventory(): ?TInventory
    {
        return $this->inventory;
    }

    public function setInventory(?TInventory $inventory): self
    {
        $this->inventory = $inventory;

        return $this;
    }

    public function getSubItemType(): ?string
    {
        return $this->subItemType;
    }

    public function setSubItemType(?string $subItemType): self
    {
        $this->subItemType = $subItemType;

        return $this;
    }

    public function getSubItemDescription(): ?string
    {
        return $this->subItemDescription;
    }

    public function setSubItemDescription(?string $subItemDescription): self
    {
        $this->subItemDescription = $subItemDescription;

        return $this;
    }

    public function getSubItemQty(): ?int
    {
        return $this->subItemQty;
    }

    public function setSubItemQty(?int $subItemQty): self
    {
        $this->subItemQty = $subItemQty;

        return $this;
    }

    public function getServiceCost(): ?string
    {
        return $this->serviceCost;
    }

    public function setServiceCost(?string $serviceCost): self
    {
        $this->serviceCost = $serviceCost;

        return $this;
    }

    public function getServicePrice(): ?string
    {
        return $this->servicePrice;
    }

    public function setServicePrice(?string $servicePrice): self
    {
        $this->servicePrice = $servicePrice;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getStaff(): ?TStaffMembers
    {
        return $this->staff;
    }

    public function setStaff(?TStaffMembers $staff): self
    {
        $this->staff = $staff;

        return $this;
    }

    public function getTotalCost(): ?string
    {
        return $this->totalCost;
    }

    public function setTotalCost(?string $totalCost): self
    {
        $this->totalCost = $totalCost;

        return $this;
    }
}
