<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSettingsRepository;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\OrderFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Validator\Constraints\DateTime;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_settings:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_settings:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(OrderFilter::class, properties={ "verticalLevelNo": "ASC" })
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "workflow": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSettingsRepository::class)
 */

class TSettings
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $outAccountNoInitials;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $outAccountNoPreceedings;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $mpesaPaybill;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $smsApiKey;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $institutionName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $officialEmail;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $reportHeader1;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $reportHeader2;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $reportFooter1;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $reportFooter2;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $businessMantra;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $uploadsFolder;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $outAccountLastCode;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $inAccountLastCode;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $inAccountNoInitials;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $inAccountNoPreceedings;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $outPatientRegistrationStage;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $outPatientWorkflow;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $inPatientRegistrationStage;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_settings:read", "t_settings:write"})
     */
    private $inPatientWorkflow;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getOutAccountNoInitials(): ?string
    {
        return $this->outAccountNoInitials;
    }

    public function setOutAccountNoInitials(?string $outAccountNoInitials): self
    {
        $this->outAccountNoInitials = $outAccountNoInitials;

        return $this;
    }

    public function getOutAccountNoPreceedings(): ?string
    {
        return $this->outAccountNoPreceedings;
    }

    public function setOutAccountNoPreceedings(?string $outAccountNoPreceedings): self
    {
        $this->outAccountNoPreceedings = $outAccountNoPreceedings;

        return $this;
    }

    public function getMpesaPaybill(): ?string
    {
        return $this->mpesaPaybill;
    }

    public function setMpesaPaybill(?string $mpesaPaybill): self
    {
        $this->mpesaPaybill = $mpesaPaybill;

        return $this;
    }

    public function getSmsApiKey(): ?string
    {
        return $this->smsApiKey;
    }

    public function setSmsApiKey(?string $smsApiKey): self
    {
        $this->smsApiKey = $smsApiKey;

        return $this;
    }

    public function getInstitutionName(): ?string
    {
        return $this->institutionName;
    }

    public function setInstitutionName(?string $institutionName): self
    {
        $this->institutionName = $institutionName;

        return $this;
    }

    public function getOfficialEmail(): ?string
    {
        return $this->officialEmail;
    }

    public function setOfficialEmail(?string $officialEmail): self
    {
        $this->officialEmail = $officialEmail;

        return $this;
    }

    public function getReportHeader1(): ?string
    {
        return $this->reportHeader1;
    }

    public function setReportHeader1(?string $reportHeader1): self
    {
        $this->reportHeader1 = $reportHeader1;

        return $this;
    }

    public function getReportHeader2(): ?string
    {
        return $this->reportHeader2;
    }

    public function setReportHeader2(?string $reportHeader2): self
    {
        $this->reportHeader2 = $reportHeader2;

        return $this;
    }

    public function getReportFooter1(): ?string
    {
        return $this->reportFooter1;
    }

    public function setReportFooter1(?string $reportFooter1): self
    {
        $this->reportFooter1 = $reportFooter1;

        return $this;
    }

    public function getReportFooter2(): ?string
    {
        return $this->reportFooter2;
    }

    public function setReportFooter2(?string $reportFooter2): self
    {
        $this->reportFooter2 = $reportFooter2;

        return $this;
    }

    public function getBusinessMantra(): ?string
    {
        return $this->businessMantra;
    }

    public function setBusinessMantra(?string $businessMantra): self
    {
        $this->businessMantra = $businessMantra;

        return $this;
    }

    public function getUploadsFolder(): ?string
    {
        return $this->uploadsFolder;
    }

    public function setUploadsFolder(?string $uploadsFolder): self
    {
        $this->uploadsFolder = $uploadsFolder;

        return $this;
    }

    public function getOutAccountLastCode(): ?int
    {
        return $this->outAccountLastCode;
    }

    public function setOutAccountLastCode(?int $outAccountLastCode): self
    {
        $this->outAccountLastCode = $outAccountLastCode;

        return $this;
    }

    public function getInAccountLastCode(): ?int
    {
        return $this->inAccountLastCode;
    }

    public function setInAccountLastCode(?int $inAccountLastCode): self
    {
        $this->inAccountLastCode = $inAccountLastCode;

        return $this;
    }

    public function getInAccountNoInitials(): ?string
    {
        return $this->inAccountNoInitials;
    }

    public function setInAccountNoInitials(?string $inAccountNoInitials): self
    {
        $this->inAccountNoInitials = $inAccountNoInitials;

        return $this;
    }

    public function getInAccountNoPreceedings(): ?string
    {
        return $this->inAccountNoPreceedings;
    }

    public function setInAccountNoPreceedings(?string $inAccountNoPreceedings): self
    {
        $this->inAccountNoPreceedings = $inAccountNoPreceedings;

        return $this;
    }

    public function getOutPatientRegistrationStage(): ?int
    {
        return $this->outPatientRegistrationStage;
    }

    public function setOutPatientRegistrationStage(?int $outPatientRegistrationStage): self
    {
        $this->outPatientRegistrationStage = $outPatientRegistrationStage;

        return $this;
    }

    public function getOutPatientWorkflow(): ?int
    {
        return $this->outPatientWorkflow;
    }

    public function setOutPatientWorkflow(?int $outPatientWorkflow): self
    {
        $this->outPatientWorkflow = $outPatientWorkflow;

        return $this;
    }

    public function getInPatientRegistrationStage(): ?int
    {
        return $this->inPatientRegistrationStage;
    }

    public function setInPatientRegistrationStage(?int $inPatientRegistrationStage): self
    {
        $this->inPatientRegistrationStage = $inPatientRegistrationStage;

        return $this;
    }

    public function getInPatientWorkflow(): ?int
    {
        return $this->inPatientWorkflow;
    }

    public function setInPatientWorkflow(?int $inPatientWorkflow): self
    {
        $this->inPatientWorkflow = $inPatientWorkflow;

        return $this;
    }

}
