<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSponsorsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_sponsors:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_sponsors:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSponsorsRepository::class)
 */

class TSponsors
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_sponsors:read", "t_sponsors:write", "t_sponsors_assignings:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_sponsors:read", "t_sponsors:write", "t_sponsors_assignings:read", "t_payments:read"})
     */
    private $name;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_sponsors:read", "t_sponsors:write", "t_sponsors_assignings:read"})
     */
    private $amountlimit;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $note;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TAllAccounts::class, mappedBy="sponsor")
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $tAllAccounts;

    /**
     * @ORM\OneToMany(targetEntity=TPayments::class, mappedBy="sponsor")
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $tPayments;

    /**
     * @ORM\OneToMany(targetEntity=TSponsorsAssigning::class, mappedBy="sponsor")
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $tSponsorsAssignings;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_sponsors:read", "t_sponsors:write", "t_sponsors_assignings:read" })
     */
    private $phone;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $phone2;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $email;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_sponsors:read", "t_sponsors:write"})
     */
    private $contactPerson;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tSponsors")
     * @Groups({"t_sponsors:read", "t_sponsors:write", "t_sponsors_assignings:read"})
     */
    private $coa;

    public function __construct()
    {
        $this->tAllAccounts = new ArrayCollection();
        $this->tPayments = new ArrayCollection();
        $this->tSponsorsAssignings = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getAmountlimit(): ?string
    {
        return $this->amountlimit;
    }

    public function setAmountlimit(?string $amountlimit): self
    {
        $this->amountlimit = $amountlimit;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TAllAccounts[]
     */
    public function getTAllAccounts(): Collection
    {
        return $this->tAllAccounts;
    }

    public function addTAllAccounts(TAllAccounts $tAllAccounts): self
    {
        if (!$this->tAllAccounts->contains($tAllAccounts)) {
            $this->tAllAccounts[] = $tAllAccounts;
            $tAllAccounts->setSponsor($this);
        }

        return $this;
    }

    public function removeTAllAccounts(TAllAccounts $tAllAccounts): self
    {
        if ($this->tAllAccounts->removeElement($tAllAccounts)) {
            // set the owning side to null (unless already changed)
            if ($tAllAccounts->getSponsor() === $this) {
                $tAllAccounts->setSponsor(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPayments[]
     */
    public function getTPayments(): Collection
    {
        return $this->tPayments;
    }

    public function addTPayments(TPayments $tPayments): self
    {
        if (!$this->tPayments->contains($tPayments)) {
            $this->tPayments[] = $tPayments;
            $tPayments->setSponsor($this);
        }

        return $this;
    }

    public function removeTPayments(TPayments $tPayments): self
    {
        if ($this->tPayments->removeElement($tPayments)) {
            // set the owning side to null (unless already changed)
            if ($tPayments->getSponsor() === $this) {
                $tPayments->setSponsor(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSponsorsAssigning[]
     */
    public function getTSponsorsAssignings(): Collection
    {
        return $this->tSponsorsAssignings;
    }

    public function addTSponsorsAssigning(TSponsorsAssigning $tSponsorsAssigning): self
    {
        if (!$this->tSponsorsAssignings->contains($tSponsorsAssigning)) {
            $this->tSponsorsAssignings[] = $tSponsorsAssigning;
            $tSponsorsAssigning->setSponsor($this);
        }

        return $this;
    }

    public function removeTSponsorsAssigning(TSponsorsAssigning $tSponsorsAssigning): self
    {
        if ($this->tSponsorsAssignings->removeElement($tSponsorsAssigning)) {
            // set the owning side to null (unless already changed)
            if ($tSponsorsAssigning->getSponsor() === $this) {
                $tSponsorsAssigning->setSponsor(null);
            }
        }

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    public function getPhone2(): ?string
    {
        return $this->phone2;
    }

    public function setPhone2(?string $phone2): self
    {
        $this->phone2 = $phone2;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getContactPerson(): ?string
    {
        return $this->contactPerson;
    }

    public function setContactPerson(?string $contactPerson): self
    {
        $this->contactPerson = $contactPerson;

        return $this;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }
}
