<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSponsorsAssigningRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_sponsors_assignings:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_sponsors_assignings:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "account": "exact", "sponsor": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSponsorsAssigningRepository::class)
 */

class TSponsorsAssigning
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_sponsors_assignings:read", "t_sponsors_assignings:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TSponsors::class, inversedBy="tSponsorsAssignings")
     * @Groups({"t_sponsors_assignings:read", "t_sponsors_assignings:write"})
     */
    private $sponsor;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tSponsorsAssignings")
     * @Groups({"t_sponsors_assignings:read", "t_sponsors_assignings:write"})
     */
    private $account;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_sponsors_assignings:read", "t_sponsors_assignings:write"})
     */
    private $note;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_sponsors_assignings:read", "t_sponsors_assignings:write"})
     */
    private $status;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSponsor(): ?TSponsors
    {
        return $this->sponsor;
    }

    public function setSponsor(?TSponsors $sponsor): self
    {
        $this->sponsor = $sponsor;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }
}
