<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStaffMembersRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_staff_members:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_staff_members:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TStaffMembersRepository::class)
 */

class TStaffMembers
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write", "t_transactions_details:read", "t_salaries_defineds:read", "t_accounts_transactions_temp:read", "t_salary_advances:read", "t_other_earnings_deductions:read"})
     */
    private $staffName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $phone;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $phone2;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $email;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $nationalId;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $kraPin;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $dob;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $employmentDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $nextOfKinName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $nextOfKinRelation;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $nextOfKinPhoneNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $gender;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $firstName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $middleName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $lastName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $profilePhoto;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="staffMember")
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TServicesDetails::class, mappedBy="staff")
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $tServicesDetails;

    /**
     * @ORM\ManyToOne(targetEntity=TStaffTypes::class, inversedBy="tStaffMembers")
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $staffType;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tStaffMembers")
     * @Groups({"t_staff_members:read", "t_staff_members:write"})
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity=TSalariesDefined::class, mappedBy="staffMember")
     */
    private $tSalariesDefineds;

    public function __construct()
    {
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tServicesDetails = new ArrayCollection();
        $this->tSalariesDefineds = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStaffName(): ?string
    {
        return $this->staffName;
    }

    public function setStaffName(?string $staffName): self
    {
        $this->staffName = $staffName;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    public function getPhone2(): ?string
    {
        return $this->phone2;
    }

    public function setPhone2(?string $phone2): self
    {
        $this->phone2 = $phone2;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getNationalId(): ?string
    {
        return $this->nationalId;
    }

    public function setNationalId(?string $nationalId): self
    {
        $this->nationalId = $nationalId;

        return $this;
    }

    public function getKraPin(): ?string
    {
        return $this->kraPin;
    }

    public function setKraPin(?string $kraPin): self
    {
        $this->kraPin = $kraPin;

        return $this;
    }

    public function getDob(): ?\DateTimeInterface
    {
        return $this->dob;
    }

    public function setDob(?\DateTimeInterface $dob): self
    {
        $this->dob = $dob;

        return $this;
    }

    public function getEmploymentDate(): ?\DateTimeInterface
    {
        return $this->employmentDate;
    }

    public function setEmploymentDate(?\DateTimeInterface $employmentDate): self
    {
        $this->employmentDate = $employmentDate;

        return $this;
    }

    public function getNextOfKinName(): ?string
    {
        return $this->nextOfKinName;
    }

    public function setNextOfKinName(?string $nextOfKinName): self
    {
        $this->nextOfKinName = $nextOfKinName;

        return $this;
    }

    public function getNextOfKinRelation(): ?string
    {
        return $this->nextOfKinRelation;
    }

    public function setNextOfKinRelation(?string $nextOfKinRelation): self
    {
        $this->nextOfKinRelation = $nextOfKinRelation;

        return $this;
    }

    public function getNextOfKinPhoneNo(): ?string
    {
        return $this->nextOfKinPhoneNo;
    }

    public function setNextOfKinPhoneNo(?string $nextOfKinPhoneNo): self
    {
        $this->nextOfKinPhoneNo = $nextOfKinPhoneNo;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getMiddleName(): ?string
    {
        return $this->middleName;
    }

    public function setMiddleName(?string $middleName): self
    {
        $this->middleName = $middleName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getProfilePhoto(): ?string
    {
        return $this->profilePhoto;
    }

    public function setProfilePhoto(?string $profilePhoto): self
    {
        $this->profilePhoto = $profilePhoto;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setStaffMember($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getStaffMember() === $this) {
                $tTransactionsDetail->setStaffMember(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TServicesDetails[]
     */
    public function getTServicesDetails(): Collection
    {
        return $this->tServicesDetails;
    }

    public function addTServicesDetail(TServicesDetails $tServicesDetail): self
    {
        if (!$this->tServicesDetails->contains($tServicesDetail)) {
            $this->tServicesDetails[] = $tServicesDetail;
            $tServicesDetail->setStaff($this);
        }

        return $this;
    }

    public function removeTServicesDetail(TServicesDetails $tServicesDetail): self
    {
        if ($this->tServicesDetails->removeElement($tServicesDetail)) {
            // set the owning side to null (unless already changed)
            if ($tServicesDetail->getStaff() === $this) {
                $tServicesDetail->setStaff(null);
            }
        }

        return $this;
    }

    public function getStaffType(): ?TStaffTypes
    {
        return $this->staffType;
    }

    public function setStaffType(?TStaffTypes $staffType): self
    {
        $this->staffType = $staffType;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|TSalariesDefined[]
     */
    public function getTSalariesDefineds(): Collection
    {
        return $this->tSalariesDefineds;
    }

    public function addTSalariesDefined(TSalariesDefined $tSalariesDefined): self
    {
        if (!$this->tSalariesDefineds->contains($tSalariesDefined)) {
            $this->tSalariesDefineds[] = $tSalariesDefined;
            $tSalariesDefined->setStaffMember($this);
        }

        return $this;
    }

    public function removeTSalariesDefined(TSalariesDefined $tSalariesDefined): self
    {
        if ($this->tSalariesDefineds->removeElement($tSalariesDefined)) {
            // set the owning side to null (unless already changed)
            if ($tSalariesDefined->getStaffMember() === $this) {
                $tSalariesDefined->setStaffMember(null);
            }
        }

        return $this;
    }
}
