<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStaffTypesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_staff_types:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_staff_types:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TStaffTypesRepository::class)
 */

class TStaffTypes
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_staff_types:read", "t_staff_types:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_staff_types:read", "t_staff_types:write"})
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=TStaffMembers::class, mappedBy="staffType")
     * @Groups({"t_staff_types:read", "t_staff_types:write"})
     */
    private $tStaffMembers;

    public function __construct()
    {
        $this->tStaffMembers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|TStaffMembers[]
     */
    public function getTStaffMembers(): Collection
    {
        return $this->tStaffMembers;
    }

    public function addTStaffMember(TStaffMembers $tStaffMember): self
    {
        if (!$this->tStaffMembers->contains($tStaffMember)) {
            $this->tStaffMembers[] = $tStaffMember;
            $tStaffMember->setStaffType($this);
        }

        return $this;
    }

    public function removeTStaffMember(TStaffMembers $tStaffMember): self
    {
        if ($this->tStaffMembers->removeElement($tStaffMember)) {
            // set the owning side to null (unless already changed)
            if ($tStaffMember->getStaffType() === $this) {
                $tStaffMember->setStaffType(null);
            }
        }

        return $this;
    }
}
