<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStagesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_stages:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_stages:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TStagesRepository::class)
 */

class TStages
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_stages:read", "t_stages:write", "t_stages_levels:read", "t_que_manager:read", "t_transactions_details:read", "t_stages_accesses:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TStagesLevels::class, inversedBy="tStages")
     * @Groups({"t_stages:read", "t_stages:write", "t_stages_accesses:read"})
     */
    private $stageLevel;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_stages:read", "t_stages:write", "t_nextstages:read", "t_all_accounts:read", "t_stages_levels:read", "t_que_manager:read", "t_transactions_details:read", "t_invoices:read", "t_transactions_details_temps:read", "t_service_fees:read", "t_stages_accesses:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_stages:read", "t_stages:write", "t_stages_levels:read"})
     */
    private $stageType;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TNextstages::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tNextstages;

    /**
     * @ORM\OneToMany(targetEntity=TQueManager::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tQueManagers;

    /**
     * @ORM\OneToMany(targetEntity=TStagesTimelines::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tStagesTimelines;

    /**
     * @ORM\OneToMany(targetEntity=TServiceFees::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tServiceFees;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tInvoices;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tAccountsTransactions;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tTransactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TNextstages::class, mappedBy="nextStageTwo")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tNextStagesTwo;

    /**
     * @ORM\OneToMany(targetEntity=TQueManager::class, mappedBy="prevStage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $queManagersPrevStage;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetailsTemps::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tTransactionsDetailsTemps;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactionsTemp::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tAccountsTransactionsTemps;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_stages:read", "t_stages:write", "t_stages_levels:read"})
     */
    private $quePatientsOrServices;

    /**
     * @ORM\OneToMany(targetEntity=TStagesAccess::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages:write"})
     */
    private $tStagesAccesses;

    /**
     * @ORM\OneToMany(targetEntity=TWardsInPatient::class, mappedBy="stage")
     * @Groups({"t_stages:read", "t_stages_levels:read"})
     */
    private $tWardsInPatients;

    public function __construct()
    {
        $this->tNextstages = new ArrayCollection();
        $this->tQueManagers = new ArrayCollection();
        $this->tStagesTimelines = new ArrayCollection();
        $this->tServiceFees = new ArrayCollection();
        $this->tInvoices = new ArrayCollection();
        $this->tAccountsTransactions = new ArrayCollection();
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tNextStagesTwo = new ArrayCollection();
        $this->queManagersPrevStage = new ArrayCollection();
        $this->tTransactionsDetailsTemps = new ArrayCollection();
        $this->tAccountsTransactionsTemps = new ArrayCollection();
        $this->tStagesAccesses = new ArrayCollection();
        $this->tWardsInPatients = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStageLevel(): ?TStagesLevels
    {
        return $this->stageLevel;
    }

    public function setStageLevel(?TStagesLevels $stageLevel): self
    {
        $this->stageLevel = $stageLevel;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStageType(): ?string
    {
        return $this->stageType;
    }

    public function setStageType(?string $stageType): self
    {
        $this->stageType = $stageType;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TNextstages[]
     */
    public function getTNextstages(): Collection
    {
        return $this->tNextstages;
    }

    public function addTNextstage(TNextstages $tNextstage): self
    {
        if (!$this->tNextstages->contains($tNextstage)) {
            $this->tNextstages[] = $tNextstage;
            $tNextstage->setStage($this);
        }

        return $this;
    }

    public function removeTNextstage(TNextstages $tNextstage): self
    {
        if ($this->tNextstages->removeElement($tNextstage)) {
            // set the owning side to null (unless already changed)
            if ($tNextstage->getStage() === $this) {
                $tNextstage->setStage(null);
            }
        }

        return $this;
    }


    /**
     * @return Collection|TQueManager[]
     */
    public function getTQueManagers(): Collection
    {
        return $this->tQueManagers;
    }

    public function addTQueManager(TQueManager $tQueManager): self
    {
        if (!$this->tQueManagers->contains($tQueManager)) {
            $this->tQueManagers[] = $tQueManager;
            $tQueManager->setStage($this);
        }

        return $this;
    }

    public function removeTQueManager(TQueManager $tQueManager): self
    {
        if ($this->tQueManagers->removeElement($tQueManager)) {
            // set the owning side to null (unless already changed)
            if ($tQueManager->getStage() === $this) {
                $tQueManager->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TStagesTimelines[]
     */
    public function getTStagesTimelines(): Collection
    {
        return $this->tStagesTimelines;
    }

    public function addTStagesTimeline(TStagesTimelines $tStagesTimeline): self
    {
        if (!$this->tStagesTimelines->contains($tStagesTimeline)) {
            $this->tStagesTimelines[] = $tStagesTimeline;
            $tStagesTimeline->setStage($this);
        }

        return $this;
    }

    public function removeTStagesTimeline(TStagesTimelines $tStagesTimeline): self
    {
        if ($this->tStagesTimelines->removeElement($tStagesTimeline)) {
            // set the owning side to null (unless already changed)
            if ($tStagesTimeline->getStage() === $this) {
                $tStagesTimeline->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TServiceFees[]
     */
    public function getTServiceFees(): Collection
    {
        return $this->tServiceFees;
    }

    public function addTServiceFee(TServiceFees $tServiceFee): self
    {
        if (!$this->tServiceFees->contains($tServiceFee)) {
            $this->tServiceFees[] = $tServiceFee;
            $tServiceFee->setStage($this);
        }

        return $this;
    }

    public function removeTServiceFee(TServiceFees $tServiceFee): self
    {
        if ($this->tServiceFees->removeElement($tServiceFee)) {
            // set the owning side to null (unless already changed)
            if ($tServiceFee->getStage() === $this) {
                $tServiceFee->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setStage($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getStage() === $this) {
                $tInvoice->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransactions)) {
            $this->tAccountsTransactions[] = $tAccountsTransactions;
            $tAccountsTransactions->setStage($this);
        }

        return $this;
    }

    public function removeTAccountsTransactions(TAccountsTransactions $tAccountsTransactions): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransactions)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactions->getStage() === $this) {
                $tAccountsTransactions->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setStage($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getStage() === $this) {
                $tTransactionsDetail->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TNextstages[]
     */
    public function getTNextStagesTwo(): Collection
    {
        return $this->tNextStagesTwo;
    }

    public function addTNextStagesTwo(TNextstages $tNextStagesTwo): self
    {
        if (!$this->tNextStagesTwo->contains($tNextStagesTwo)) {
            $this->tNextStagesTwo[] = $tNextStagesTwo;
            $tNextStagesTwo->setNextStageTwo($this);
        }

        return $this;
    }

    public function removeTNextStagesTwo(TNextstages $tNextStagesTwo): self
    {
        if ($this->tNextStagesTwo->removeElement($tNextStagesTwo)) {
            // set the owning side to null (unless already changed)
            if ($tNextStagesTwo->getNextStageTwo() === $this) {
                $tNextStagesTwo->setNextStageTwo(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TQueManager[]
     */
    public function getQueManagersPrevStage(): Collection
    {
        return $this->queManagersPrevStage;
    }

    public function addQueManagersPrevStage(TQueManager $queManagersPrevStage): self
    {
        if (!$this->queManagersPrevStage->contains($queManagersPrevStage)) {
            $this->queManagersPrevStage[] = $queManagersPrevStage;
            $queManagersPrevStage->setPrevStage($this);
        }

        return $this;
    }

    public function removeQueManagersPrevStage(TQueManager $queManagersPrevStage): self
    {
        if ($this->queManagersPrevStage->removeElement($queManagersPrevStage)) {
            // set the owning side to null (unless already changed)
            if ($queManagersPrevStage->getPrevStage() === $this) {
                $queManagersPrevStage->setPrevStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetailsTemps[]
     */
    public function getTTransactionsDetailsTemps(): Collection
    {
        return $this->tTransactionsDetailsTemps;
    }

    public function addTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if (!$this->tTransactionsDetailsTemps->contains($tTransactionsDetailsTemp)) {
            $this->tTransactionsDetailsTemps[] = $tTransactionsDetailsTemp;
            $tTransactionsDetailsTemp->setStage($this);
        }

        return $this;
    }

    public function removeTTransactionsDetailsTemp(TTransactionsDetailsTemps $tTransactionsDetailsTemp): self
    {
        if ($this->tTransactionsDetailsTemps->removeElement($tTransactionsDetailsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetailsTemp->getStage() === $this) {
                $tTransactionsDetailsTemp->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactionsTemp[]
     */
    public function getTAccountsTransactionsTemps(): Collection
    {
        return $this->tAccountsTransactionsTemps;
    }

    public function addTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if (!$this->tAccountsTransactionsTemps->contains($tAccountsTransactionsTemp)) {
            $this->tAccountsTransactionsTemps[] = $tAccountsTransactionsTemp;
            $tAccountsTransactionsTemp->setStage($this);
        }

        return $this;
    }

    public function removeTAccountsTransactionsTemp(TAccountsTransactionsTemp $tAccountsTransactionsTemp): self
    {
        if ($this->tAccountsTransactionsTemps->removeElement($tAccountsTransactionsTemp)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransactionsTemp->getStage() === $this) {
                $tAccountsTransactionsTemp->setStage(null);
            }
        }

        return $this;
    }

    public function getQuePatientsOrServices(): ?string
    {
        return $this->quePatientsOrServices;
    }

    public function setQuePatientsOrServices(?string $quePatientsOrServices): self
    {
        $this->quePatientsOrServices = $quePatientsOrServices;

        return $this;
    }

    /**
     * @return Collection|TStagesAccess[]
     */
    public function getTStagesAccesses(): Collection
    {
        return $this->tStagesAccesses;
    }

    public function addTStagesAccess(TStagesAccess $tStagesAccess): self
    {
        if (!$this->tStagesAccesses->contains($tStagesAccess)) {
            $this->tStagesAccesses[] = $tStagesAccess;
            $tStagesAccess->setStage($this);
        }

        return $this;
    }

    public function removeTStagesAccess(TStagesAccess $tStagesAccess): self
    {
        if ($this->tStagesAccesses->removeElement($tStagesAccess)) {
            // set the owning side to null (unless already changed)
            if ($tStagesAccess->getStage() === $this) {
                $tStagesAccess->setStage(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TWardsInPatient[]
     */
    public function getTWardsInPatients(): Collection
    {
        return $this->tWardsInPatients;
    }

    public function addTWardsInPatient(TWardsInPatient $tWardsInPatient): self
    {
        if (!$this->tWardsInPatients->contains($tWardsInPatient)) {
            $this->tWardsInPatients[] = $tWardsInPatient;
            $tWardsInPatient->setStage($this);
        }

        return $this;
    }

    public function removeTWardsInPatient(TWardsInPatient $tWardsInPatient): self
    {
        if ($this->tWardsInPatients->removeElement($tWardsInPatient)) {
            // set the owning side to null (unless already changed)
            if ($tWardsInPatient->getStage() === $this) {
                $tWardsInPatient->setStage(null);
            }
        }

        return $this;
    }
}
