<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStagesAccessRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_stages_accesses:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_stages_accesses:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "accessGroup": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TStagesAccessRepository::class)
 */

class TStagesAccess
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_stages_accesses:read", "t_stages_accesses:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tStagesAccesses")
     * @Groups({"t_stages_accesses:read", "t_stages_accesses:write"})
     */
    private $stage;

    /**
     * @ORM\ManyToOne(targetEntity=TGroups::class, inversedBy="tStagesAccesses")
     * @Groups({"t_stages_accesses:read", "t_stages_accesses:write"})
     */
    private $accessGroup;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getAccessGroup(): ?TGroups
    {
        return $this->accessGroup;
    }

    public function setAccessGroup(?TGroups $accessGroup): self
    {
        $this->accessGroup = $accessGroup;

        return $this;
    }
}
