<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStagesLevelsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\OrderFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_stages_levels:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_stages_levels:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(OrderFilter::class, properties={ "verticalLevelNo": "ASC" })
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "workflow": "exact" })
 * @ORM\Entity(repositoryClass=TStagesLevelsRepository::class)
 */

class TStagesLevels
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_stages_levels:read", "t_stages_levels:write"})
     */
    private $id;

    /**
     * @ORM\OneToMany(targetEntity=TStages::class, mappedBy="stageLevel")
     * @Groups({"t_stages_levels:read", "t_stages_levels:write"})
     */
    private $tStages;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_stages_levels:read", "t_stages_levels:write", "t_stages:read"})
     */
    private $horizontalLevelNo;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_stages_levels:read", "t_stages_levels:write", "t_stages:read"})
     */
    private $verticalLevelNo;

    /**
     * @ORM\ManyToOne(targetEntity=TWorkflows::class, inversedBy="tStagesLevels")
     * @Groups({"t_stages_levels:read", "t_stages_levels:write", "t_stages:read", "t_stages_accesses:read"})
     */
    private $workflow;

    public function __construct()
    {
        $this->tStages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return Collection|TStages[]
     */
    public function getTStages(): Collection
    {
        return $this->tStages;
    }

    public function addTStages(TStages $tStages): self
    {
        if (!$this->tStages->contains($tStages)) {
            $this->tStages[] = $tStages;
            $tStages->setStageLevel($this);
        }

        return $this;
    }

    public function removeTStages(TStages $tStages): self
    {
        if ($this->tStages->removeElement($tStages)) {
            // set the owning side to null (unless already changed)
            if ($tStages->getStageLevel() === $this) {
                $tStages->setStageLevel(null);
            }
        }

        return $this;
    }

    public function getHorizontalLevelNo(): ?int
    {
        return $this->horizontalLevelNo;
    }

    public function setHorizontalLevelNo(?int $horizontalLevelNo): self
    {
        $this->horizontalLevelNo = $horizontalLevelNo;

        return $this;
    }

    public function getVerticalLevelNo(): ?int
    {
        return $this->verticalLevelNo;
    }

    public function setVerticalLevelNo(?int $verticalLevelNo): self
    {
        $this->verticalLevelNo = $verticalLevelNo;

        return $this;
    }

    public function getWorkflow(): ?TWorkflows
    {
        return $this->workflow;
    }

    public function setWorkflow(?TWorkflows $workflow): self
    {
        $this->workflow = $workflow;

        return $this;
    }
}
