<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStagesTimelinesRepository;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_stages_timelines:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_stages_timelines:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TStagesTimelinesRepository::class)
 */

class TStagesTimelines
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_stages_timelines:read", "t_stages_timelines:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tStagesTimelines")
     * @Groups({"t_stages_timelines:read", "t_stages_timelines:write"})
     */
    private $stage;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tStagesTimelines")
     * @Groups({"t_stages_timelines:read", "t_stages_timelines:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TQueManager::class, inversedBy="tStagesTimelines")
     * @Groups({"t_stages_timelines:read", "t_stages_timelines:write"})
     */
    private $que;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_stages_timelines:read", "t_stages_timelines:write"})
     */
    private $entryDate;

    /**
     * @ORM\Column(type="time", nullable=true)
     * @Groups({"t_stages_timelines:read", "t_stages_timelines:write"})
     */
    private $entryTime;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_stages_timelines:read", "t_stages_timelines:write"})
     */
    private $status;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getQue(): ?TQueManager
    {
        return $this->que;
    }

    public function setQue(?TQueManager $que): self
    {
        $this->que = $que;

        return $this;
    }

    public function getEntryDate(): ?\DateTimeInterface
    {
        return $this->entryDate;
    }

    public function setEntryDate(?\DateTimeInterface $entryDate): self
    {
        $this->entryDate = $entryDate;

        return $this;
    }

    public function getEntryTime(): ?\DateTimeInterface
    {
        return $this->entryTime;
    }

    public function setEntryTime(?\DateTimeInterface $entryTime): self
    {
        $this->entryTime = $entryTime;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }
}
