<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSubCountiesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_sub_counties:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_sub_counties:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "county": "exact" })
 * @ORM\Entity(repositoryClass=TSubCountiesRepository::class)
 */

class TSubCounties
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_sub_counties:read", "t_sub_counties:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCounties::class, inversedBy="tSubCounties")
     * @Groups({"t_sub_counties:read", "t_sub_counties:write"})
     */
    private $county;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_sub_counties:read", "t_sub_counties:write", "t_wards:read", "t_wards:write"})
     */
    private $name;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_sub_counties:read", "t_sub_counties:write"})
     */
    private $note;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_sub_counties:read", "t_sub_counties:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TWards::class, mappedBy="subCounty")
     * @Groups({"t_sub_counties:read", "t_sub_counties:write"})
     */
    private $tWards;

    public function __construct()
    {
        $this->tWards = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCounty(): ?TCounties
    {
        return $this->county;
    }

    public function setCounty(?TCounties $county): self
    {
        $this->county = $county;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TWards[]
     */
    public function getTWards(): Collection
    {
        return $this->tWards;
    }

    public function addTWards(TWards $tWards): self
    {
        if (!$this->tWards->contains($tWards)) {
            $this->tWards[] = $tWards;
            $tWards->setSubCounty($this);
        }

        return $this;
    }

    public function removeTWards(TWards $tWards): self
    {
        if ($this->tWards->removeElement($tWards)) {
            // set the owning side to null (unless already changed)
            if ($tWards->getSubCounty() === $this) {
                $tWards->setSubCounty(null);
            }
        }

        return $this;
    }
}
