<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TTransactionsDetailsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_transactions_details:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_transactions_details:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "account": "exact", "que": "exact", "paymentStatus": "exact", "processingStatus": "exact", "transactionType": "exact", "transactionsAccsTemps": "exact", "item": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TTransactionsDetailsRepository::class)
 */

class TTransactionsDetails
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write", "t_invoices:read", "t_accounts_transactions:read"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TQueManager::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $que;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $stage;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TAccountsTransactions::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $accountTransactions;

    /**
     * @ORM\ManyToOne(targetEntity=TServiceFees::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $services;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write", "t_inventory:read", "t_accounts_transactions:read"})
     */
    private $quantity;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write", "t_accounts_transactions:read"})
     */
    private $cost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write", "t_accounts_transactions:read"})
     */
    private $price;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write", "t_accounts_transactions:read"})
     */
    private $totalCost;

    /**
     * @ORM\ManyToOne(targetEntity=User::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $user;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $transactionDocDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $month;

    /**
     * @ORM\ManyToOne(targetEntity=TInventory::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write", "t_accounts_transactions:read"})
     */
    private $item;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $explanations;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $remarks;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $paymentStatus;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="transactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $tInvoices;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $processingStatus;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $transactionType;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $transactionsAccsTemps;

    /**
     * @ORM\ManyToOne(targetEntity=TDiagnosis::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $diagnosis;

    /**
     * @ORM\ManyToOne(targetEntity=TCoas::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $coa;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $billable;

    /**
     * @ORM\ManyToOne(targetEntity=TDosages::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $dosage;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $dosageDays;

    /**
     * @ORM\ManyToOne(targetEntity=TReferrals::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $referrals;

    /**
     * @ORM\OneToMany(targetEntity=TUnfullfilledPrescriptions::class, mappedBy="transactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $tUnfullfilledPrescriptions;

    /**
     * @ORM\ManyToOne(targetEntity=TStaffMembers::class, inversedBy="tTransactionsDetails")
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $staffMember;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $discPercent;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $discAmount;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $taxPercent;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $taxAmount;

    /**
     * @ORM\ManyToOne(targetEntity=TPayslipItems::class, inversedBy="tTransactionsDetails")
     */
    private $payslip;

    /**
     * @ORM\ManyToOne(targetEntity=TSalaryAdvances::class, inversedBy="tTransactionsDetails")
     */
    private $salaryAdvance;

    /**
     * @ORM\ManyToOne(targetEntity=TOtherEarningsDeductions::class, inversedBy="tTransactionsDetails")
     */
    private $otherEarningsAndDeductions;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details:read", "t_transactions_details:write"})
     */
    private $priority;

    public function __construct()
    {
        $this->tInvoices = new ArrayCollection();
        $this->tUnfullfilledPrescriptions = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getQue(): ?TQueManager
    {
        return $this->que;
    }

    public function setQue(?TQueManager $que): self
    {
        $this->que = $que;

        return $this;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getAccountTransactions(): ?TAccountsTransactions
    {
        return $this->accountTransactions;
    }

    public function setAccountTransactions(?TAccountsTransactions $accountTransactions): self
    {
        $this->accountTransactions = $accountTransactions;

        return $this;
    }

    public function getServices(): ?TServiceFees
    {
        return $this->services;
    }

    public function setServices(?TServiceFees $services): self
    {
        $this->services = $services;

        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $quantity): self
    {
        $this->quantity = $quantity;

        return $this;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getTotalCost(): ?string
    {
        return $this->totalCost;
    }

    public function setTotalCost(?string $totalCost): self
    {
        $this->totalCost = $totalCost;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactionDocDate(): ?\DateTimeInterface
    {
        return $this->transactionDocDate;
    }

    public function setTransactionDocDate(?\DateTimeInterface $transactionDocDate): self
    {
        $this->transactionDocDate = $transactionDocDate;

        return $this;
    }

    public function getYear(): ?int
    {
        return $this->year;
    }

    public function setYear(?int $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?string
    {
        return $this->month;
    }

    public function setMonth(?string $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getItem(): ?TInventory
    {
        return $this->item;
    }

    public function setItem(?TInventory $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getExplanations(): ?string
    {
        return $this->explanations;
    }

    public function setExplanations(?string $explanations): self
    {
        $this->explanations = $explanations;

        return $this;
    }

    public function getRemarks(): ?string
    {
        return $this->remarks;
    }

    public function setRemarks(?string $remarks): self
    {
        $this->remarks = $remarks;

        return $this;
    }

    public function getPaymentStatus(): ?string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(?string $paymentStatus): self
    {
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setTransactionsDetails($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getTransactionsDetails() === $this) {
                $tInvoice->setTransactionsDetails(null);
            }
        }

        return $this;
    }

    public function getProcessingStatus(): ?string
    {
        return $this->processingStatus;
    }

    public function setProcessingStatus(?string $processingStatus): self
    {
        $this->processingStatus = $processingStatus;

        return $this;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    public function getTransactionsAccsTemps(): ?int
    {
        return $this->transactionsAccsTemps;
    }

    public function setTransactionsAccsTemps(?int $transactionsAccsTemps): self
    {
        $this->transactionsAccsTemps = $transactionsAccsTemps;

        return $this;
    }

    public function getDiagnosis(): ?TDiagnosis
    {
        return $this->diagnosis;
    }

    public function setDiagnosis(?TDiagnosis $diagnosis): self
    {
        $this->diagnosis = $diagnosis;

        return $this;
    }

    public function getCoa(): ?TCoas
    {
        return $this->coa;
    }

    public function setCoa(?TCoas $coa): self
    {
        $this->coa = $coa;

        return $this;
    }

    public function getBillable(): ?string
    {
        return $this->billable;
    }

    public function setBillable(?string $billable): self
    {
        $this->billable = $billable;

        return $this;
    }

    public function getDosage(): ?TDosages
    {
        return $this->dosage;
    }

    public function setDosage(?TDosages $dosage): self
    {
        $this->dosage = $dosage;

        return $this;
    }

    public function getDosageDays(): ?int
    {
        return $this->dosageDays;
    }

    public function setDosageDays(int $dosageDays): self
    {
        $this->dosageDays = $dosageDays;

        return $this;
    }

    public function getReferrals(): ?TReferrals
    {
        return $this->referrals;
    }

    public function setReferrals(?TReferrals $referrals): self
    {
        $this->referrals = $referrals;

        return $this;
    }

    /**
     * @return Collection|TUnfullfilledPrescriptions[]
     */
    public function getTUnfullfilledPrescriptions(): Collection
    {
        return $this->tUnfullfilledPrescriptions;
    }

    public function addTUnfullfilledPrescription(TUnfullfilledPrescriptions $tUnfullfilledPrescription): self
    {
        if (!$this->tUnfullfilledPrescriptions->contains($tUnfullfilledPrescription)) {
            $this->tUnfullfilledPrescriptions[] = $tUnfullfilledPrescription;
            $tUnfullfilledPrescription->setTransactionsDetails($this);
        }

        return $this;
    }

    public function removeTUnfullfilledPrescription(TUnfullfilledPrescriptions $tUnfullfilledPrescription): self
    {
        if ($this->tUnfullfilledPrescriptions->removeElement($tUnfullfilledPrescription)) {
            // set the owning side to null (unless already changed)
            if ($tUnfullfilledPrescription->getTransactionsDetails() === $this) {
                $tUnfullfilledPrescription->setTransactionsDetails(null);
            }
        }

        return $this;
    }

    public function getStaffMember(): ?TStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    public function getDiscPercent(): ?string
    {
        return $this->discPercent;
    }

    public function setDiscPercent(?string $discPercent): self
    {
        $this->discPercent = $discPercent;

        return $this;
    }

    public function getDiscAmount(): ?string
    {
        return $this->discAmount;
    }

    public function setDiscAmount(?string $discAmount): self
    {
        $this->discAmount = $discAmount;

        return $this;
    }

    public function getTaxPercent(): ?string
    {
        return $this->taxPercent;
    }

    public function setTaxPercent(?string $taxPercent): self
    {
        $this->taxPercent = $taxPercent;

        return $this;
    }

    public function getTaxAmount(): ?string
    {
        return $this->taxAmount;
    }

    public function setTaxAmount(?string $taxAmount): self
    {
        $this->taxAmount = $taxAmount;

        return $this;
    }

    public function getPayslip(): ?TPayslipItems
    {
        return $this->payslip;
    }

    public function setPayslip(?TPayslipItems $payslip): self
    {
        $this->payslip = $payslip;

        return $this;
    }

    public function getSalaryAdvance(): ?TSalaryAdvances
    {
        return $this->salaryAdvance;
    }

    public function setSalaryAdvance(?TSalaryAdvances $salaryAdvance): self
    {
        $this->salaryAdvance = $salaryAdvance;

        return $this;
    }

    public function getOtherEarningsAndDeductions(): ?TOtherEarningsDeductions
    {
        return $this->otherEarningsAndDeductions;
    }

    public function setOtherEarningsAndDeductions(?TOtherEarningsDeductions $otherEarningsAndDeductions): self
    {
        $this->otherEarningsAndDeductions = $otherEarningsAndDeductions;

        return $this;
    }

    public function getPriority(): ?string
    {
        return $this->priority;
    }

    public function setPriority(?string $priority): self
    {
        $this->priority = $priority;

        return $this;
    }
}
