<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TTransactionsDetailsTempsRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_transactions_details_temps:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_transactions_details_temps:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "account": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TTransactionsDetailsTempsRepository::class)
 */

class TTransactionsDetailsTemps
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write", "t_accounts_transactions_temp:read"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TQueManager::class, inversedBy="tTransactionsDetailsTemps")
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $que;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tTransactionsDetailsTemps")
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write", "t_accounts_transactions_temp:read"})
     */
    private $stage;

    /**
     * @ORM\ManyToOne(targetEntity=TAllAccounts::class, inversedBy="tTransactionsDetailsTemps")
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity=TServiceFees::class, inversedBy="tTransactionsDetailsTemps")
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $services;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $quantity;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $cost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $price;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write", "t_accounts_transactions_temp:read"})
     */
    private $totalCost;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $transactionSystemDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $transactionDocDate;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $year;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $month;

    /**
     * @ORM\ManyToOne(targetEntity=TInventory::class, inversedBy="tTransactionsDetailsTemps")
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $item;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write", "t_accounts_transactions_temp:read"})
     */
    private $explanations;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write", "t_accounts_transactions_temp:read"})
     */
    private $remarks;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $paymentStatus;

    /**
     * @ORM\ManyToOne(targetEntity=TAccountsTransactionsTemp::class, inversedBy="tTransactionsDetailsTemps")
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $accountTransactionsTemps;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_transactions_details_temps:read", "t_transactions_details_temps:write"})
     */
    private $transactionType;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="transactionsDetailsTemps")
     */
    private $tInvoices;

    public function __construct()
    {
        $this->tInvoices = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getQue(): ?TQueManager
    {
        return $this->que;
    }

    public function setQue(?TQueManager $que): self
    {
        $this->que = $que;

        return $this;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    public function getAccount(): ?TAllAccounts
    {
        return $this->account;
    }

    public function setAccount(?TAllAccounts $account): self
    {
        $this->account = $account;

        return $this;
    }

    public function getServices(): ?TServiceFees
    {
        return $this->services;
    }

    public function setServices(?TServiceFees $services): self
    {
        $this->services = $services;

        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $quantity): self
    {
        $this->quantity = $quantity;

        return $this;
    }

    public function getCost(): ?string
    {
        return $this->cost;
    }

    public function setCost(?string $cost): self
    {
        $this->cost = $cost;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getTotalCost(): ?string
    {
        return $this->totalCost;
    }

    public function setTotalCost(?string $totalCost): self
    {
        $this->totalCost = $totalCost;

        return $this;
    }

    public function getTransactionSystemDate(): ?\DateTimeInterface
    {
        return $this->transactionSystemDate;
    }

    public function setTransactionSystemDate(?\DateTimeInterface $transactionSystemDate): self
    {
        $this->transactionSystemDate = $transactionSystemDate;

        return $this;
    }

    public function getTransactionDocDate(): ?\DateTimeInterface
    {
        return $this->transactionDocDate;
    }

    public function setTransactionDocDate(?\DateTimeInterface $transactionDocDate): self
    {
        $this->transactionDocDate = $transactionDocDate;

        return $this;
    }

    public function getYear(): ?int
    {
        return $this->year;
    }

    public function setYear(?int $year): self
    {
        $this->year = $year;

        return $this;
    }

    public function getMonth(): ?int
    {
        return $this->month;
    }

    public function setMonth(?int $month): self
    {
        $this->month = $month;

        return $this;
    }

    public function getItem(): ?TInventory
    {
        return $this->item;
    }

    public function setItem(?TInventory $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getExplanations(): ?string
    {
        return $this->explanations;
    }

    public function setExplanations(?string $explanations): self
    {
        $this->explanations = $explanations;

        return $this;
    }

    public function getRemarks(): ?string
    {
        return $this->remarks;
    }

    public function setRemarks(?string $remarks): self
    {
        $this->remarks = $remarks;

        return $this;
    }

    public function getPaymentStatus(): ?string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(?string $paymentStatus): self
    {
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    public function getAccountTransactionsTemps(): ?TAccountsTransactionsTemp
    {
        return $this->accountTransactionsTemps;
    }

    public function setAccountTransactionsTemps(?TAccountsTransactionsTemp $accountTransactionsTemps): self
    {
        $this->accountTransactionsTemps = $accountTransactionsTemps;

        return $this;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setTransactionsDetailsTemps($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getTransactionsDetailsTemps() === $this) {
                $tInvoice->setTransactionsDetailsTemps(null);
            }
        }

        return $this;
    }

}
