<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TTransactionsSerialNoRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=TTransactionsSerialNoRepository::class)
 */
#[ApiResource]
class TTransactionsSerialNo
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $transactionSystemNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     */
    private $transactionType;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTransactionSystemNo(): ?string
    {
        return $this->transactionSystemNo;
    }

    public function setTransactionSystemNo(?string $transactionSystemNo): self
    {
        $this->transactionSystemNo = $transactionSystemNo;

        return $this;
    }

    public function getTransactionType(): ?string
    {
        return $this->transactionType;
    }

    public function setTransactionType(?string $transactionType): self
    {
        $this->transactionType = $transactionType;

        return $this;
    }
}
