<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TUnfullfilledPrescriptionsRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\DateFilter;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_unfullfilled_prescriptions:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_unfullfilled_prescriptions:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TUnfullfilledPrescriptionsRepository::class)
 */

class TUnfullfilledPrescriptions
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_unfullfilled_prescriptions:read", "t_unfullfilled_prescriptions:write"})
     */
    private $id;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({"t_unfullfilled_prescriptions:read", "t_unfullfilled_prescriptions:write"})
     */
    private $prescription_date;

    /**
     * @ORM\ManyToOne(targetEntity=TInventory::class, inversedBy="tUnfullfilledPrescriptions")
     * @Groups({"t_unfullfilled_prescriptions:read", "t_unfullfilled_prescriptions:write"})
     */
    private $item;

    /**
     * @ORM\ManyToOne(targetEntity=TTransactionsDetails::class, inversedBy="tUnfullfilledPrescriptions")
     * @Groups({"t_unfullfilled_prescriptions:read", "t_unfullfilled_prescriptions:write"})
     */
    private $transactionsDetails;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPrescriptionDate(): ?\DateTimeInterface
    {
        return $this->prescription_date;
    }

    public function setPrescriptionDate(?\DateTimeInterface $prescription_date): self
    {
        $this->prescription_date = $prescription_date;

        return $this;
    }

    public function getItem(): ?TInventory
    {
        return $this->item;
    }

    public function setItem(?TInventory $item): self
    {
        $this->item = $item;

        return $this;
    }

    public function getTransactionsDetails(): ?TTransactionsDetails
    {
        return $this->transactionsDetails;
    }

    public function setTransactionsDetails(?TTransactionsDetails $transactionsDetails): self
    {
        $this->transactionsDetails = $transactionsDetails;

        return $this;
    }
}
