<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWardsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_wards:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_wards:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWardsRepository::class)
 */

class TWards
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_wards:read", "t_wards:write"})
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TSubCounties::class, inversedBy="tWards")
     * @Groups({"t_wards:read", "t_wards:write"})
     */
    private $subCounty;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_wards:read", "t_wards:write"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_wards:read", "t_wards:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TAllAccounts::class, mappedBy="ward")
     * @Groups({"t_wards:read", "t_wards:write"})
     */
    private $tAllAccounts;

    public function __construct()
    {
        $this->tAllAccounts = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSubCounty(): ?TSubCounties
    {
        return $this->subCounty;
    }

    public function setSubCounty(?TSubCounties $subCounty): self
    {
        $this->subCounty = $subCounty;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TAllAccounts[]
     */
    public function getTAllAccounts(): Collection
    {
        return $this->tAllAccounts;
    }

    public function addTAllAccount(TAllAccounts $tAllAccount): self
    {
        if (!$this->tAllAccounts->contains($tAllAccount)) {
            $this->tAllAccounts[] = $tAllAccount;
            $tAllAccount->setWard($this);
        }

        return $this;
    }

    public function removeTAllAccount(TAllAccounts $tAllAccount): self
    {
        if ($this->tAllAccounts->removeElement($tAllAccount)) {
            // set the owning side to null (unless already changed)
            if ($tAllAccount->getWard() === $this) {
                $tAllAccount->setWard(null);
            }
        }

        return $this;
    }

}
