<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWardsBedsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_wards_beds:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_wards_beds:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "wardFloor": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWardsBedsRepository::class)
 */

class TWardsBeds
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_wards_beds:read", "t_wards_beds:write", "t_wards_in_patient:read", "t_wards_floors:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_wards_beds:read", "t_wards_beds:write", "t_wards_in_patient:read", "t_wards_floors:read"})
     */
    private $bedNo;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_wards_beds:read", "t_wards_beds:write", "t_wards_in_patient:read", "t_wards_floors:read"})
     */
    private $bedType;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_wards_beds:read", "t_wards_beds:write", "t_wards_in_patient:read"})
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity=TWardsFloors::class, inversedBy="tWardsBeds")
     * @Groups({"t_wards_beds:read", "t_wards_beds:write"})
     */
    private $wardFloor;

    /**
     * @ORM\OneToMany(targetEntity=TBedsAssignings::class, mappedBy="bed")
     * @Groups({"t_wards_beds:read", "t_wards_beds:write"})
     */
    private $tBedsAssignings;

    /**
     * @ORM\OneToMany(targetEntity=TAllAccounts::class, mappedBy="currentAdmissionBed")
     * @Groups({"t_wards_beds:read", "t_wards_beds:write", "t_wards_in_patient:read", "t_wards_floors:read"})
     */
    private $tAllAccounts;

    /**
     * @ORM\ManyToOne(targetEntity=TWardsInPatient::class, inversedBy="tWardsBeds")
     * @Groups({"t_wards_beds:read", "t_wards_beds:write"})
     */
    private $wardsInPatient;

    public function __construct()
    {
        $this->tBedsAssignings = new ArrayCollection();
        $this->tAllAccounts = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getBedNo(): ?string
    {
        return $this->bedNo;
    }

    public function setBedNo(?string $bedNo): self
    {
        $this->bedNo = $bedNo;

        return $this;
    }

    public function getBedType(): ?string
    {
        return $this->bedType;
    }

    public function setBedType(?string $bedType): self
    {
        $this->bedType = $bedType;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getWardFloor(): ?TWardsFloors
    {
        return $this->wardFloor;
    }

    public function setWardFloor(?TWardsFloors $wardFloor): self
    {
        $this->wardFloor = $wardFloor;

        return $this;
    }

    /**
     * @return Collection|TBedsAssignings[]
     */
    public function getTBedsAssignings(): Collection
    {
        return $this->tBedsAssignings;
    }

    public function addTBedsAssigning(TBedsAssignings $tBedsAssigning): self
    {
        if (!$this->tBedsAssignings->contains($tBedsAssigning)) {
            $this->tBedsAssignings[] = $tBedsAssigning;
            $tBedsAssigning->setBed($this);
        }

        return $this;
    }

    public function removeTBedsAssigning(TBedsAssignings $tBedsAssigning): self
    {
        if ($this->tBedsAssignings->removeElement($tBedsAssigning)) {
            // set the owning side to null (unless already changed)
            if ($tBedsAssigning->getBed() === $this) {
                $tBedsAssigning->setBed(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAllAccounts[]
     */
    public function getTAllAccounts(): Collection
    {
        return $this->tAllAccounts;
    }

    public function addTAllAccount(TAllAccounts $tAllAccount): self
    {
        if (!$this->tAllAccounts->contains($tAllAccount)) {
            $this->tAllAccounts[] = $tAllAccount;
            $tAllAccount->setCurrentAdmissionBed($this);
        }

        return $this;
    }

    public function removeTAllAccount(TAllAccounts $tAllAccount): self
    {
        if ($this->tAllAccounts->removeElement($tAllAccount)) {
            // set the owning side to null (unless already changed)
            if ($tAllAccount->getCurrentAdmissionBed() === $this) {
                $tAllAccount->setCurrentAdmissionBed(null);
            }
        }

        return $this;
    }

    public function getWardsInPatient(): ?TWardsInPatient
    {
        return $this->wardsInPatient;
    }

    public function setWardsInPatient(?TWardsInPatient $wardsInPatient): self
    {
        $this->wardsInPatient = $wardsInPatient;

        return $this;
    }
}
