<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWardsFloorsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_wards_floors:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_wards_floors:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "wardPatient": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWardsFloorsRepository::class)
 */

class TWardsFloors
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_wards_floors:read", "t_wards_floors:write", "t_wards_in_patient:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_wards_floors:read", "t_wards_floors:write", "t_wards_in_patient:read", "t_wards_beds:read"})
     */
    private $floorName;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_wards_floors:read", "t_wards_floors:write"})
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity=TWardsInPatient::class, inversedBy="tWardsFloors")
     * @Groups({"t_wards_floors:read", "t_wards_floors:write"})
     */
    private $wardPatient;

    /**
     * @ORM\OneToMany(targetEntity=TWardsBeds::class, mappedBy="wardFloor")
     * @Groups({"t_wards_floors:read", "t_wards_floors:write", "t_wards_in_patient:read"})
     */
    private $tWardsBeds;

    /**
     * @ORM\OneToMany(targetEntity=TAllAccounts::class, mappedBy="currentAdmissionFloor")
     */
    private $tAllAccounts;

    public function __construct()
    {
        $this->tWardsBeds = new ArrayCollection();
        $this->tAllAccounts = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFloorName(): ?string
    {
        return $this->floorName;
    }

    public function setFloorName(?string $floorName): self
    {
        $this->floorName = $floorName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getWardPatient(): ?TWardsInPatient
    {
        return $this->wardPatient;
    }

    public function setWardPatient(?TWardsInPatient $wardPatient): self
    {
        $this->wardPatient = $wardPatient;

        return $this;
    }

    /**
     * @return Collection|TWardsBeds[]
     */
    public function getTWardsBeds(): Collection
    {
        return $this->tWardsBeds;
    }

    public function addTWardsBed(TWardsBeds $tWardsBed): self
    {
        if (!$this->tWardsBeds->contains($tWardsBed)) {
            $this->tWardsBeds[] = $tWardsBed;
            $tWardsBed->setWardFloor($this);
        }

        return $this;
    }

    public function removeTWardsBed(TWardsBeds $tWardsBed): self
    {
        if ($this->tWardsBeds->removeElement($tWardsBed)) {
            // set the owning side to null (unless already changed)
            if ($tWardsBed->getWardFloor() === $this) {
                $tWardsBed->setWardFloor(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAllAccounts[]
     */
    public function getTAllAccounts(): Collection
    {
        return $this->tAllAccounts;
    }

    public function addTAllAccount(TAllAccounts $tAllAccount): self
    {
        if (!$this->tAllAccounts->contains($tAllAccount)) {
            $this->tAllAccounts[] = $tAllAccount;
            $tAllAccount->setCurrentAdmissionFloor($this);
        }

        return $this;
    }

    public function removeTAllAccount(TAllAccounts $tAllAccount): self
    {
        if ($this->tAllAccounts->removeElement($tAllAccount)) {
            // set the owning side to null (unless already changed)
            if ($tAllAccount->getCurrentAdmissionFloor() === $this) {
                $tAllAccount->setCurrentAdmissionFloor(null);
            }
        }

        return $this;
    }
}
