<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWardsInPatientRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use App\Repository\TWardsBedsRepository;

use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_wards_in_patient:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_wards_in_patient:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "status": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWardsInPatientRepository::class)
 */

class TWardsInPatient
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_wards_in_patient:read", "t_wards_in_patient:write", "t_wards_floors:read", "t_wards_beds:read", "t_stages:read", "t_stages_levels:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_wards_in_patient:read", "t_wards_in_patient:write", "t_wards_floors:read", "t_stages:read", "t_stages_levels:read"})
     */
    private $wardName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({"t_wards_in_patient:read", "t_wards_in_patient:write"})
     */
    private $wardCode;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({"t_wards_in_patient:read", "t_wards_in_patient:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TWardsFloors::class, mappedBy="wardPatient")
     * @Groups({"t_wards_in_patient:read", "t_wards_in_patient:write"})
     */
    private $tWardsFloors;

    /**
     * @ORM\OneToMany(targetEntity=TAllAccounts::class, mappedBy="currentAdmissionWard")
     */
    private $tAllAccounts;

    /**
     * @ORM\ManyToOne(targetEntity=TStages::class, inversedBy="tWardsInPatients")
     * @Groups({"t_wards_in_patient:read", "t_wards_in_patient:write"})
     */
    private $stage;

    /**
     * @ORM\OneToMany(targetEntity=TWardsBeds::class, mappedBy="wardsInPatient")
     */
    private $tWardsBeds;

    public function __construct()
    {
        $this->tWardsFloors = new ArrayCollection();
        $this->tAllAccounts = new ArrayCollection();
        $this->tWardsBeds = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getWardName(): ?string
    {
        return $this->wardName;
    }

    public function setWardName(?string $wardName): self
    {
        $this->wardName = $wardName;

        return $this;
    }

    public function getWardCode(): ?string
    {
        return $this->wardCode;
    }

    public function setWardCode(?string $wardCode): self
    {
        $this->wardCode = $wardCode;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TWardsFloors[]
     */
    public function getTWardsFloors(): Collection
    {
        return $this->tWardsFloors;
    }

    public function addTWardsFloor(TWardsFloors $tWardsFloor): self
    {
        if (!$this->tWardsFloors->contains($tWardsFloor)) {
            $this->tWardsFloors[] = $tWardsFloor;
            $tWardsFloor->setWardPatient($this);
        }

        return $this;
    }

    public function removeTWardsFloor(TWardsFloors $tWardsFloor): self
    {
        if ($this->tWardsFloors->removeElement($tWardsFloor)) {
            // set the owning side to null (unless already changed)
            if ($tWardsFloor->getWardPatient() === $this) {
                $tWardsFloor->setWardPatient(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAllAccounts[]
     */
    public function getTAllAccounts(): Collection
    {
        return $this->tAllAccounts;
    }

    public function addTAllAccount(TAllAccounts $tAllAccount): self
    {
        if (!$this->tAllAccounts->contains($tAllAccount)) {
            $this->tAllAccounts[] = $tAllAccount;
            $tAllAccount->setCurrentAdmissionWard($this);
        }

        return $this;
    }

    public function removeTAllAccount(TAllAccounts $tAllAccount): self
    {
        if ($this->tAllAccounts->removeElement($tAllAccount)) {
            // set the owning side to null (unless already changed)
            if ($tAllAccount->getCurrentAdmissionWard() === $this) {
                $tAllAccount->setCurrentAdmissionWard(null);
            }
        }

        return $this;
    }

    public function getStage(): ?TStages
    {
        return $this->stage;
    }

    public function setStage(?TStages $stage): self
    {
        $this->stage = $stage;

        return $this;
    }

    /**
     * @return Collection|TWardsBeds[]
     */
    public function getTWardsBeds(): Collection
    {
        return $this->tWardsBeds;
    }

    public function addTWardsBed(TWardsBeds $tWardsBed): self
    {
        if (!$this->tWardsBeds->contains($tWardsBed)) {
            $this->tWardsBeds[] = $tWardsBed;
            $tWardsBed->setWardsInPatient($this);
        }

        return $this;
    }

    public function removeTWardsBed(TWardsBeds $tWardsBed): self
    {
        if ($this->tWardsBeds->removeElement($tWardsBed)) {
            // set the owning side to null (unless already changed)
            if ($tWardsBed->getWardsInPatient() === $this) {
                $tWardsBed->setWardsInPatient(null);
            }
        }

        return $this;
    }
}
