<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWorkflowsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use ApiPlatform\Core\Annotation\ApiFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_workflows:read"}, "enable_max_depth" = "true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_workflows:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWorkflowsRepository::class)
 */

class TWorkflows
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"t_workflows:read", "t_workflows:write", "t_stages_levels:read", "t_que_manager:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_workflows:read", "t_workflows:write", "t_stages_levels:read", "t_stages_accesses:read", "t_stages:read"})
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({"t_workflows:read", "t_workflows:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TStagesLevels::class, mappedBy="workflow")
     * @Groups({"t_workflows:read", "t_workflows:write"})
     */
    private $tStagesLevels;

    /**
     * @ORM\OneToMany(targetEntity=TQueManager::class, mappedBy="workflow")
     */
    private $tQueManagers;

    public function __construct()
    {
        $this->tStagesLevels = new ArrayCollection();
        $this->tQueManagers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TStagesLevels[]
     */
    public function getTStagesLevels(): Collection
    {
        return $this->tStagesLevels;
    }

    public function addTStagesLevel(TStagesLevels $tStagesLevel): self
    {
        if (!$this->tStagesLevels->contains($tStagesLevel)) {
            $this->tStagesLevels[] = $tStagesLevel;
            $tStagesLevel->setWorkflow($this);
        }

        return $this;
    }

    public function removeTStagesLevel(TStagesLevels $tStagesLevel): self
    {
        if ($this->tStagesLevels->removeElement($tStagesLevel)) {
            // set the owning side to null (unless already changed)
            if ($tStagesLevel->getWorkflow() === $this) {
                $tStagesLevel->setWorkflow(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TQueManager[]
     */
    public function getTQueManagers(): Collection
    {
        return $this->tQueManagers;
    }

    public function addTQueManager(TQueManager $tQueManager): self
    {
        if (!$this->tQueManagers->contains($tQueManager)) {
            $this->tQueManagers[] = $tQueManager;
            $tQueManager->setWorkflow($this);
        }

        return $this;
    }

    public function removeTQueManager(TQueManager $tQueManager): self
    {
        if ($this->tQueManagers->removeElement($tQueManager)) {
            // set the owning side to null (unless already changed)
            if ($tQueManager->getWorkflow() === $this) {
                $tQueManager->setWorkflow(null);
            }
        }

        return $this;
    }
}
