<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use App\Repository\UserRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Security\Core\User\PasswordAuthenticatedUserInterface;
use Symfony\Component\Security\Core\User\UserInterface;

use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"User:read"}, "enable_max_depth" = "true"},
 *    denormalizationContext={"groups"={"User:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "email": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=UserRepository::class)
 */
class User implements UserInterface, PasswordAuthenticatedUserInterface
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({"User:read", "TGroups:read", "login_activities:read"})
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=180, unique=true)
     * @Groups({"User:read", "User:write", "TGroups:read", "ttransactions_details:read"})
     */
    private $email;

    /**
     * @ORM\Column(type="json")
     */
    private $roles = [];

    /**
     * @var string The hashed password
     * @ORM\Column(type="string")
     * @Groups({"User:write"})
     */
    private $password;

    /**
     * @ORM\OneToMany(targetEntity=ApiToken::class, mappedBy="user", orphanRemoval=true)
     */
    private $apiTokens;

    /**
     * @ORM\Column(type="integer")
     * @Groups({"User:read", "User:write"})
     */
    private $groupId;

    /**
     * @ORM\Column(type="string", length=15)
     * @Groups({"User:read", "User:write"})
     */
    private $phoneNo;

    /**
     * @ORM\Column(type="string", length=15)
     * @Groups({"User:read", "User:write"})
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TInvoices::class, mappedBy="user")
     */
    private $tInvoices;

    /**
     * @ORM\OneToMany(targetEntity=TAccountsTransactions::class, mappedBy="user")
     */
    private $tAccountsTransactions;

    /**
     * @ORM\OneToMany(targetEntity=TTransactionsDetails::class, mappedBy="user")
     */
    private $tTransactionsDetails;

    /**
     * @ORM\OneToMany(targetEntity=TQueManager::class, mappedBy="queBy")
     */
    private $tQueManagers;

    /**
     * @ORM\Column(type="integer", nullable=true)
     * @Groups({"User:read"})
     */
    private $staffId;

    /**
     * @ORM\OneToMany(targetEntity=TLoginActivities::class, mappedBy="user")
     */
    private $tLoginActivities;

    /**
     * @ORM\OneToMany(targetEntity=TAllAccounts::class, mappedBy="user")
     */
    private $tAllAccounts;

    /**
     * @ORM\OneToMany(targetEntity=TInventory::class, mappedBy="user")
     */
    private $tInventories;

    /**
     * @ORM\OneToMany(targetEntity=TPayments::class, mappedBy="user")
     */
    private $tPayments;

    /**
     * @ORM\OneToMany(targetEntity=TStaffMembers::class, mappedBy="user")
     */
    private $tStaffMembers;

    public function __construct()
    {
        $this->apiTokens = new ArrayCollection();
        $this->tInvoices = new ArrayCollection();
        $this->tAccountsTransactions = new ArrayCollection();
        $this->tTransactionsDetails = new ArrayCollection();
        $this->tQueManagers = new ArrayCollection();
        $this->tLoginActivities = new ArrayCollection();
        $this->tAllAccounts = new ArrayCollection();
        $this->tInventories = new ArrayCollection();
        $this->tPayments = new ArrayCollection();
        $this->tStaffMembers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    /**
     * A visual identifier that represents this user.
     *
     * @see UserInterface
     */
    public function getUserIdentifier(): string
    {
        return (string) $this->email;
    }

    /**
     * @deprecated since Symfony 5.3, use getUserIdentifier instead
     */
    public function getUsername(): string
    {
        return (string) $this->email;
    }

    /**
     * @see UserInterface
     */
    public function getRoles(): array
    {
        $roles = $this->roles;
        // guarantee every user at least has ROLE_USER
        $roles[] = 'ROLE_USER';

        return array_unique($roles);
    }

    public function setRoles(array $roles): self
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * @see PasswordAuthenticatedUserInterface
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    /**
     * Returning a salt is only needed, if you are not using a modern
     * hashing algorithm (e.g. bcrypt or sodium) in your security.yaml.
     *
     * @see UserInterface
     */
    public function getSalt(): ?string
    {
        return null;
    }

    /**
     * @see UserInterface
     */
    public function eraseCredentials()
    {
        // If you store any temporary, sensitive data on the user, clear it here
        $this->plainPassword = null;
    }

    /**
     * @return Collection|ApiToken[]
     */
    public function getApiTokens(): Collection
    {
        return $this->apiTokens;
    }

    public function addApiToken(ApiToken $apiToken): self
    {
        if (!$this->apiTokens->contains($apiToken)) {
            $this->apiTokens[] = $apiToken;
            $apiToken->setUser($this);
        }

        return $this;
    }

    public function removeApiToken(ApiToken $apiToken): self
    {
        if ($this->apiTokens->removeElement($apiToken)) {
            // set the owning side to null (unless already changed)
            if ($apiToken->getUser() === $this) {
                $apiToken->setUser(null);
            }
        }

        return $this;
    }

    public function getGroupId(): ?int
    {
        return $this->groupId;
    }

    public function setGroupId(?int $groupId): self
    {
        $this->groupId = $groupId;

        return $this;
    }

    public function getPhoneNo(): ?string
    {
        return $this->phoneNo;
    }

    public function setPhoneNo(string $phoneNo): self
    {
        $this->phoneNo = $phoneNo;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TInvoices[]
     */
    public function getTInvoices(): Collection
    {
        return $this->tInvoices;
    }

    public function addTInvoice(TInvoices $tInvoice): self
    {
        if (!$this->tInvoices->contains($tInvoice)) {
            $this->tInvoices[] = $tInvoice;
            $tInvoice->setUser($this);
        }

        return $this;
    }

    public function removeTInvoice(TInvoices $tInvoice): self
    {
        if ($this->tInvoices->removeElement($tInvoice)) {
            // set the owning side to null (unless already changed)
            if ($tInvoice->getUser() === $this) {
                $tInvoice->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAccountsTransactions[]
     */
    public function getTAccountsTransactions(): Collection
    {
        return $this->tAccountsTransactions;
    }

    public function addTAccountsTransaction(TAccountsTransactions $tAccountsTransaction): self
    {
        if (!$this->tAccountsTransactions->contains($tAccountsTransaction)) {
            $this->tAccountsTransactions[] = $tAccountsTransaction;
            $tAccountsTransaction->setUser($this);
        }

        return $this;
    }

    public function removeTAccountsTransaction(TAccountsTransactions $tAccountsTransaction): self
    {
        if ($this->tAccountsTransactions->removeElement($tAccountsTransaction)) {
            // set the owning side to null (unless already changed)
            if ($tAccountsTransaction->getUser() === $this) {
                $tAccountsTransaction->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTransactionsDetails[]
     */
    public function getTTransactionsDetails(): Collection
    {
        return $this->tTransactionsDetails;
    }

    public function addTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if (!$this->tTransactionsDetails->contains($tTransactionsDetail)) {
            $this->tTransactionsDetails[] = $tTransactionsDetail;
            $tTransactionsDetail->setUser($this);
        }

        return $this;
    }

    public function removeTTransactionsDetail(TTransactionsDetails $tTransactionsDetail): self
    {
        if ($this->tTransactionsDetails->removeElement($tTransactionsDetail)) {
            // set the owning side to null (unless already changed)
            if ($tTransactionsDetail->getUser() === $this) {
                $tTransactionsDetail->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TQueManager[]
     */
    public function getTQueManagers(): Collection
    {
        return $this->tQueManagers;
    }

    public function addTQueManager(TQueManager $tQueManager): self
    {
        if (!$this->tQueManagers->contains($tQueManager)) {
            $this->tQueManagers[] = $tQueManager;
            $tQueManager->setQueBy($this);
        }

        return $this;
    }

    public function removeTQueManager(TQueManager $tQueManager): self
    {
        if ($this->tQueManagers->removeElement($tQueManager)) {
            // set the owning side to null (unless already changed)
            if ($tQueManager->getQueBy() === $this) {
                $tQueManager->setQueBy(null);
            }
        }

        return $this;
    }

    public function getStaffId(): ?int
    {
        return $this->staffId;
    }

    public function setStaffId(?int $staffId): self
    {
        $this->staffId = $staffId;

        return $this;
    }

    /**
     * @return Collection|TLoginActivities[]
     */
    public function getTLoginActivities(): Collection
    {
        return $this->tLoginActivities;
    }

    public function addTLoginActivity(TLoginActivities $tLoginActivity): self
    {
        if (!$this->tLoginActivities->contains($tLoginActivity)) {
            $this->tLoginActivities[] = $tLoginActivity;
            $tLoginActivity->setUser($this);
        }

        return $this;
    }

    public function removeTLoginActivity(TLoginActivities $tLoginActivity): self
    {
        if ($this->tLoginActivities->removeElement($tLoginActivity)) {
            // set the owning side to null (unless already changed)
            if ($tLoginActivity->getUser() === $this) {
                $tLoginActivity->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAllAccounts[]
     */
    public function getTAllAccounts(): Collection
    {
        return $this->tAllAccounts;
    }

    public function addTAllAccount(TAllAccounts $tAllAccount): self
    {
        if (!$this->tAllAccounts->contains($tAllAccount)) {
            $this->tAllAccounts[] = $tAllAccount;
            $tAllAccount->setUser($this);
        }

        return $this;
    }

    public function removeTAllAccount(TAllAccounts $tAllAccount): self
    {
        if ($this->tAllAccounts->removeElement($tAllAccount)) {
            // set the owning side to null (unless already changed)
            if ($tAllAccount->getUser() === $this) {
                $tAllAccount->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TInventory[]
     */
    public function getTInventories(): Collection
    {
        return $this->tInventories;
    }

    public function addTInventory(TInventory $tInventory): self
    {
        if (!$this->tInventories->contains($tInventory)) {
            $this->tInventories[] = $tInventory;
            $tInventory->setUser($this);
        }

        return $this;
    }

    public function removeTInventory(TInventory $tInventory): self
    {
        if ($this->tInventories->removeElement($tInventory)) {
            // set the owning side to null (unless already changed)
            if ($tInventory->getUser() === $this) {
                $tInventory->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPayments[]
     */
    public function getTPayments(): Collection
    {
        return $this->tPayments;
    }

    public function addTPayment(TPayments $tPayment): self
    {
        if (!$this->tPayments->contains($tPayment)) {
            $this->tPayments[] = $tPayment;
            $tPayment->setUser($this);
        }

        return $this;
    }

    public function removeTPayment(TPayments $tPayment): self
    {
        if ($this->tPayments->removeElement($tPayment)) {
            // set the owning side to null (unless already changed)
            if ($tPayment->getUser() === $this) {
                $tPayment->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TStaffMembers[]
     */
    public function getTStaffMembers(): Collection
    {
        return $this->tStaffMembers;
    }

    public function addTStaffMember(TStaffMembers $tStaffMember): self
    {
        if (!$this->tStaffMembers->contains($tStaffMember)) {
            $this->tStaffMembers[] = $tStaffMember;
            $tStaffMember->setUser($this);
        }

        return $this;
    }

    public function removeTStaffMember(TStaffMembers $tStaffMember): self
    {
        if ($this->tStaffMembers->removeElement($tStaffMember)) {
            // set the owning side to null (unless already changed)
            if ($tStaffMember->getUser() === $this) {
                $tStaffMember->setUser(null);
            }
        }

        return $this;
    }

}
